/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.api;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.nephele.event.task.AbstractEvent;
import eu.stratosphere.nephele.template.AbstractInvokable;
import eu.stratosphere.runtime.io.Buffer;
import eu.stratosphere.runtime.io.api.BufferWriter;
import eu.stratosphere.runtime.io.api.ChannelSelector;
import eu.stratosphere.runtime.io.api.RoundRobinChannelSelector;
import eu.stratosphere.runtime.io.channels.EndOfSuperstepEvent;
import eu.stratosphere.runtime.io.network.bufferprovider.BufferProvider;
import eu.stratosphere.runtime.io.serialization.RecordSerializer;
import eu.stratosphere.runtime.io.serialization.SpanningRecordSerializer;
import java.io.IOException;

public class RecordWriter<T extends IOReadableWritable>
extends BufferWriter {
    private final BufferProvider bufferPool;
    private final ChannelSelector<T> channelSelector;
    private int numChannels;
    private RecordSerializer<T>[] serializers;

    public RecordWriter(AbstractInvokable invokable) {
        this(invokable, new RoundRobinChannelSelector());
    }

    public RecordWriter(AbstractInvokable invokable, ChannelSelector<T> channelSelector) {
        super(invokable);
        this.bufferPool = invokable.getEnvironment().getOutputBufferProvider();
        this.channelSelector = channelSelector;
    }

    public void initializeSerializers() {
        this.numChannels = this.outputGate.getNumChannels();
        this.serializers = new RecordSerializer[this.numChannels];
        for (int i = 0; i < this.numChannels; ++i) {
            this.serializers[i] = new SpanningRecordSerializer();
        }
    }

    public void emit(T record) throws IOException, InterruptedException {
        for (int targetChannel : this.channelSelector.selectChannels(record, this.numChannels)) {
            RecordSerializer<T> serializer = this.serializers[targetChannel];
            RecordSerializer.SerializationResult result = serializer.addRecord(record);
            while (result.isFullBuffer()) {
                Buffer buffer = serializer.getCurrentBuffer();
                if (buffer != null) {
                    this.sendBuffer(buffer, targetChannel);
                }
                buffer = this.bufferPool.requestBufferBlocking(this.bufferPool.getBufferSize());
                result = serializer.setNextBuffer(buffer);
            }
        }
    }

    public void flush() throws IOException, InterruptedException {
        for (int targetChannel = 0; targetChannel < this.numChannels; ++targetChannel) {
            RecordSerializer<T> serializer = this.serializers[targetChannel];
            Buffer buffer = serializer.getCurrentBuffer();
            if (buffer != null) {
                this.sendBuffer(buffer, targetChannel);
            }
            serializer.clear();
        }
    }

    @Override
    public void broadcastEvent(AbstractEvent event) throws IOException, InterruptedException {
        for (int targetChannel = 0; targetChannel < this.numChannels; ++targetChannel) {
            RecordSerializer<T> serializer = this.serializers[targetChannel];
            Buffer buffer = serializer.getCurrentBuffer();
            if (buffer == null) {
                super.sendEvent(event, targetChannel);
                continue;
            }
            super.sendBufferAndEvent(buffer, event, targetChannel);
            buffer = this.bufferPool.requestBufferBlocking(this.bufferPool.getBufferSize());
            serializer.setNextBuffer(buffer);
        }
    }

    @Override
    public void sendEndOfSuperstep() throws IOException, InterruptedException {
        for (int targetChannel = 0; targetChannel < this.numChannels; ++targetChannel) {
            RecordSerializer<T> serializer = this.serializers[targetChannel];
            Buffer buffer = serializer.getCurrentBuffer();
            if (buffer == null) {
                super.sendEvent(EndOfSuperstepEvent.INSTANCE, targetChannel);
                continue;
            }
            super.sendBufferAndEvent(buffer, EndOfSuperstepEvent.INSTANCE, targetChannel);
            buffer = this.bufferPool.requestBufferBlocking(this.bufferPool.getBufferSize());
            serializer.setNextBuffer(buffer);
        }
    }
}

