/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.api;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.nephele.template.AbstractInvokable;
import eu.stratosphere.runtime.io.api.AbstractSingleGateRecordReader;
import eu.stratosphere.runtime.io.api.Reader;
import eu.stratosphere.runtime.io.gates.InputChannelResult;
import java.io.IOException;

public class RecordReader<T extends IOReadableWritable>
extends AbstractSingleGateRecordReader<T>
implements Reader<T> {
    private final Class<T> recordType;
    private T lookahead;
    private boolean noMoreRecordsWillFollow;

    public RecordReader(AbstractInvokable taskBase, Class<T> recordType) {
        super(taskBase);
        this.recordType = recordType;
    }

    @Override
    public boolean hasNext() throws IOException, InterruptedException {
        if (this.lookahead != null) {
            return true;
        }
        if (this.noMoreRecordsWillFollow) {
            return false;
        }
        T record = this.instantiateRecordType();
        while (true) {
            InputChannelResult result = this.inputGate.readRecord(record);
            switch (result) {
                case INTERMEDIATE_RECORD_FROM_BUFFER: 
                case LAST_RECORD_FROM_BUFFER: {
                    this.lookahead = record;
                    return true;
                }
                case END_OF_SUPERSTEP: {
                    if (!this.incrementEndOfSuperstepEventAndCheck()) break;
                    return false;
                }
                case TASK_EVENT: {
                    this.handleEvent(this.inputGate.getCurrentEvent());
                    break;
                }
                case END_OF_STREAM: {
                    this.noMoreRecordsWillFollow = true;
                    return false;
                }
            }
        }
    }

    @Override
    public T next() throws IOException, InterruptedException {
        if (this.hasNext()) {
            T tmp = this.lookahead;
            this.lookahead = null;
            return tmp;
        }
        return null;
    }

    @Override
    public boolean isInputClosed() {
        return this.noMoreRecordsWillFollow;
    }

    private T instantiateRecordType() {
        try {
            return (T)((IOReadableWritable)this.recordType.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot instantiate class '" + this.recordType.getName() + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot instantiate class '" + this.recordType.getName() + "'.", e);
        }
    }
}

