/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.api;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.nephele.template.AbstractInvokable;
import eu.stratosphere.runtime.io.api.AbstractSingleGateRecordReader;
import eu.stratosphere.runtime.io.api.MutableReader;
import eu.stratosphere.runtime.io.gates.InputChannelResult;
import java.io.IOException;

public class MutableRecordReader<T extends IOReadableWritable>
extends AbstractSingleGateRecordReader<T>
implements MutableReader<T> {
    private boolean endOfStream;

    public MutableRecordReader(AbstractInvokable taskBase) {
        super(taskBase);
    }

    @Override
    public boolean next(T target) throws IOException, InterruptedException {
        if (this.endOfStream) {
            return false;
        }
        while (true) {
            InputChannelResult result = this.inputGate.readRecord(target);
            switch (result) {
                case INTERMEDIATE_RECORD_FROM_BUFFER: 
                case LAST_RECORD_FROM_BUFFER: {
                    return true;
                }
                case END_OF_SUPERSTEP: {
                    if (!this.incrementEndOfSuperstepEventAndCheck()) break;
                    return false;
                }
                case TASK_EVENT: {
                    this.handleEvent(this.inputGate.getCurrentEvent());
                    break;
                }
                case END_OF_STREAM: {
                    this.endOfStream = true;
                    return false;
                }
            }
        }
    }

    @Override
    public boolean isInputClosed() {
        return this.endOfStream;
    }

    @Override
    public void setIterative(int numEventsUntilEndOfSuperstep) {
        if (numEventsUntilEndOfSuperstep != this.getNumberOfInputChannels()) {
            throw new IllegalArgumentException("Number of events till end of superstep is different from the number of input channels.");
        }
        super.setIterative(numEventsUntilEndOfSuperstep);
    }
}

