/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.api;

import eu.stratosphere.nephele.event.task.AbstractEvent;
import eu.stratosphere.nephele.event.task.AbstractTaskEvent;
import eu.stratosphere.nephele.event.task.EventListener;
import eu.stratosphere.nephele.template.AbstractInvokable;
import eu.stratosphere.runtime.io.Buffer;
import eu.stratosphere.runtime.io.channels.EndOfSuperstepEvent;
import eu.stratosphere.runtime.io.gates.OutputGate;
import java.io.IOException;

public class BufferWriter {
    protected final OutputGate outputGate;

    public BufferWriter(AbstractInvokable invokable) {
        this.outputGate = invokable.getEnvironment().createAndRegisterOutputGate();
    }

    public void sendBuffer(Buffer buffer, int targetChannel) throws IOException, InterruptedException {
        this.outputGate.sendBuffer(buffer, targetChannel);
    }

    public void sendEvent(AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.outputGate.sendEvent(event, targetChannel);
    }

    public void sendBufferAndEvent(Buffer buffer, AbstractEvent event, int targetChannel) throws IOException, InterruptedException {
        this.outputGate.sendBufferAndEvent(buffer, event, targetChannel);
    }

    public void broadcastBuffer(Buffer buffer) throws IOException, InterruptedException {
        this.outputGate.broadcastBuffer(buffer);
    }

    public void broadcastEvent(AbstractEvent event) throws IOException, InterruptedException {
        this.outputGate.broadcastEvent(event);
    }

    public void subscribeToEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.outputGate.subscribeToEvent(eventListener, eventType);
    }

    public void unsubscribeFromEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.outputGate.unsubscribeFromEvent(eventListener, eventType);
    }

    public void sendEndOfSuperstep() throws IOException, InterruptedException {
        this.outputGate.broadcastEvent(EndOfSuperstepEvent.INSTANCE);
    }
}

