/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.io.api;

import eu.stratosphere.nephele.event.task.AbstractTaskEvent;
import eu.stratosphere.nephele.event.task.EventListener;
import eu.stratosphere.nephele.event.task.EventNotificationManager;
import eu.stratosphere.runtime.io.api.ReaderBase;

public abstract class AbstractRecordReader
implements ReaderBase {
    private final EventNotificationManager eventHandler = new EventNotificationManager();
    private int numEventsUntilEndOfSuperstep = -1;
    private int endOfSuperstepEventsCount;

    @Override
    public void subscribeToEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.eventHandler.subscribeToEvent(eventListener, eventType);
    }

    @Override
    public void unsubscribeFromEvent(EventListener eventListener, Class<? extends AbstractTaskEvent> eventType) {
        this.eventHandler.unsubscribeFromEvent(eventListener, eventType);
    }

    protected void handleEvent(AbstractTaskEvent evt) {
        this.eventHandler.deliverEvent(evt);
    }

    @Override
    public void setIterative(int numEventsUntilEndOfSuperstep) {
        this.numEventsUntilEndOfSuperstep = numEventsUntilEndOfSuperstep;
    }

    @Override
    public void startNextSuperstep() {
        if (this.numEventsUntilEndOfSuperstep == -1) {
            throw new IllegalStateException("Called 'startNextSuperstep()' in a non-iterative reader.");
        }
        if (this.endOfSuperstepEventsCount < this.numEventsUntilEndOfSuperstep) {
            throw new IllegalStateException("Premature 'startNextSuperstep()'. Not yet reached the end-of-superstep.");
        }
        this.endOfSuperstepEventsCount = 0;
    }

    @Override
    public boolean hasReachedEndOfSuperstep() {
        return this.endOfSuperstepEventsCount == this.numEventsUntilEndOfSuperstep;
    }

    protected boolean incrementEndOfSuperstepEventAndCheck() {
        if (this.numEventsUntilEndOfSuperstep == -1) {
            throw new IllegalStateException("Received EndOfSuperstep event in a non-iterative reader.");
        }
        ++this.endOfSuperstepEventsCount;
        if (this.endOfSuperstepEventsCount > this.numEventsUntilEndOfSuperstep) {
            throw new IllegalStateException("Received EndOfSuperstep events beyond the number to indicate the end of the superstep");
        }
        return this.endOfSuperstepEventsCount == this.numEventsUntilEndOfSuperstep;
    }
}

