/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.fs.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import eu.stratosphere.core.fs.FSDataOutputStream;
import eu.stratosphere.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class S3DataOutputStream
extends FSDataOutputStream {
    private static final int MAX_PART_NUMBER = 10000;
    public static final int MINIMUM_MULTIPART_SIZE = 0x500000;
    private final AmazonS3Client s3Client;
    private final boolean useRRS;
    private final byte[] buf;
    private final String bucket;
    private final String object;
    private final List<PartETag> partETags = new ArrayList<PartETag>();
    private String uploadId = null;
    private int partNumber = 1;
    private int bytesWritten = 0;

    S3DataOutputStream(AmazonS3Client s3Client, String bucket, String object, byte[] buf, boolean useRRS) {
        this.s3Client = s3Client;
        this.bucket = bucket;
        this.object = object;
        this.buf = buf;
        this.useRRS = useRRS;
    }

    public void write(int b) throws IOException {
        if (this.bytesWritten == this.buf.length) {
            this.uploadPartAndFlushBuffer();
        }
        this.buf[this.bytesWritten++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int bytesToCopy;
        for (int nextPos = off; nextPos < len; nextPos += bytesToCopy) {
            if (this.bytesWritten == this.buf.length) {
                this.uploadPartAndFlushBuffer();
            }
            bytesToCopy = Math.min(this.buf.length - this.bytesWritten, len - nextPos);
            System.arraycopy(b, nextPos, this.buf, this.bytesWritten, bytesToCopy);
            this.bytesWritten += bytesToCopy;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void close() throws IOException {
        if (this.uploadId == null) {
            if (this.bytesWritten == 0) {
                return;
            }
            InternalUploadInputStream is = new InternalUploadInputStream(this.buf, this.bytesWritten);
            ObjectMetadata om = new ObjectMetadata();
            om.setContentLength((long)this.bytesWritten);
            PutObjectRequest por = new PutObjectRequest(this.bucket, this.object, (InputStream)is, om);
            if (this.useRRS) {
                por.setStorageClass(StorageClass.ReducedRedundancy);
            } else {
                por.setStorageClass(StorageClass.Standard);
            }
            try {
                this.s3Client.putObject(por);
            }
            catch (AmazonServiceException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            this.bytesWritten = 0;
        } else {
            if (this.bytesWritten > 0) {
                this.uploadPartAndFlushBuffer();
            }
            boolean operationSuccessful = false;
            try {
                CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest(this.bucket, this.object, this.uploadId, this.partETags);
                this.s3Client.completeMultipartUpload(request);
                operationSuccessful = true;
            }
            catch (AmazonServiceException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            finally {
                if (!operationSuccessful) {
                    this.abortUpload();
                }
            }
        }
    }

    public void flush() throws IOException {
    }

    private void uploadPartAndFlushBuffer() throws IOException {
        boolean operationSuccessful = false;
        if (this.uploadId == null) {
            this.uploadId = this.initiateMultipartUpload();
        }
        try {
            if (this.partNumber >= 10000) {
                throw new IOException("Cannot upload any more data: maximum part number reached");
            }
            InternalUploadInputStream inputStream = new InternalUploadInputStream(this.buf, this.bytesWritten);
            UploadPartRequest request = new UploadPartRequest();
            request.setBucketName(this.bucket);
            request.setKey(this.object);
            request.setInputStream((InputStream)inputStream);
            request.setUploadId(this.uploadId);
            request.setPartSize((long)this.bytesWritten);
            request.setPartNumber(this.partNumber++);
            UploadPartResult result = this.s3Client.uploadPart(request);
            this.partETags.add(result.getPartETag());
            this.bytesWritten = 0;
            operationSuccessful = true;
        }
        catch (AmazonServiceException e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        finally {
            if (!operationSuccessful) {
                this.abortUpload();
            }
        }
    }

    private String initiateMultipartUpload() throws IOException {
        boolean operationSuccessful = false;
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.bucket, this.object);
        if (this.useRRS) {
            request.setStorageClass(StorageClass.ReducedRedundancy);
        } else {
            request.setStorageClass(StorageClass.Standard);
        }
        try {
            InitiateMultipartUploadResult result = this.s3Client.initiateMultipartUpload(request);
            operationSuccessful = true;
            String string = result.getUploadId();
            return string;
        }
        catch (AmazonServiceException e) {
            throw new IOException(StringUtils.stringifyException((Throwable)e));
        }
        finally {
            if (!operationSuccessful) {
                this.abortUpload();
            }
        }
    }

    private void abortUpload() {
        if (this.uploadId == null) {
            return;
        }
        try {
            AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(this.bucket, this.object, this.uploadId);
            this.s3Client.abortMultipartUpload(request);
        }
        catch (AmazonServiceException amazonServiceException) {
            // empty catch block
        }
    }

    private final class InternalUploadInputStream
    extends InputStream {
        private final byte[] srcBuf;
        private final int length;
        private int bytesRead = 0;

        private InternalUploadInputStream(byte[] srcBuf, int length) {
            this.srcBuf = S3DataOutputStream.this.buf;
            this.length = length;
        }

        @Override
        public int read() throws IOException {
            if (this.length - this.bytesRead == 0) {
                return -1;
            }
            return this.srcBuf[this.bytesRead++];
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.length - this.bytesRead == 0) {
                return -1;
            }
            int bytesToCopy = Math.min(len, this.length - this.bytesRead);
            System.arraycopy(this.srcBuf, this.bytesRead, buf, off, bytesToCopy);
            this.bytesRead += bytesToCopy;
            return bytesToCopy;
        }

        @Override
        public int available() throws IOException {
            return this.length - this.bytesRead;
        }

        @Override
        public long skip(long n) throws IOException {
            int bytesToSkip = (int)Math.min(n, Integer.MAX_VALUE);
            bytesToSkip = Math.min(this.length - this.bytesRead, bytesToSkip);
            this.bytesRead += bytesToSkip;
            return bytesToSkip;
        }
    }
}

