/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.fs.hdfs;

import eu.stratosphere.configuration.GlobalConfiguration;
import eu.stratosphere.core.fs.BlockLocation;
import eu.stratosphere.core.fs.FSDataInputStream;
import eu.stratosphere.core.fs.FSDataOutputStream;
import eu.stratosphere.core.fs.FileStatus;
import eu.stratosphere.core.fs.FileSystem;
import eu.stratosphere.runtime.fs.hdfs.DistributedBlockLocation;
import eu.stratosphere.runtime.fs.hdfs.DistributedDataInputStream;
import eu.stratosphere.runtime.fs.hdfs.DistributedDataOutputStream;
import eu.stratosphere.runtime.fs.hdfs.DistributedFileStatus;
import eu.stratosphere.util.InstantiationUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public final class DistributedFileSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(DistributedFileSystem.class);
    private static final String DEFAULT_HDFS_CLASS = "org.apache.hadoop.hdfs.DistributedFileSystem";
    private static final String HDFS_IMPLEMENTATION_KEY = "fs.hdfs.impl";
    private final Configuration conf;
    private final org.apache.hadoop.fs.FileSystem fs;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DistributedFileSystem() throws IOException {
        Class<org.apache.hadoop.fs.FileSystem> fsClass;
        block17: {
            block18: {
                Class classFromConfig;
                this.conf = DistributedFileSystem.getHadoopConfiguration();
                fsClass = null;
                LOG.debug((Object)"Trying to load HDFS class Hadoop 2.x style.");
                Object fsHandle = null;
                try {
                    Method newApi = org.apache.hadoop.fs.FileSystem.class.getMethod("getFileSystemClass", String.class, Configuration.class);
                    fsHandle = newApi.invoke(null, "hdfs", this.conf);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (fsHandle != null) {
                    if (fsHandle instanceof Class && org.apache.hadoop.fs.FileSystem.class.isAssignableFrom((Class)fsHandle)) {
                        fsClass = ((Class)fsHandle).asSubclass(org.apache.hadoop.fs.FileSystem.class);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loaded '" + fsClass.getName() + "' as HDFS class."));
                        }
                    } else {
                        LOG.debug((Object)"Unexpected return type from 'org.apache.hadoop.fs.FileSystem.getFileSystemClass(String, Configuration)'.");
                        throw new RuntimeException("The value returned from org.apache.hadoop.fs.FileSystem.getFileSystemClass(String, Configuration) is not a valid subclass of org.apache.hadoop.fs.FileSystem.");
                    }
                }
                if (fsClass != null) break block17;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Falling back to loading HDFS class old Hadoop style. Looking for HDFS class configuration entry 'fs.hdfs.impl'.");
                }
                if ((classFromConfig = this.conf.getClass(HDFS_IMPLEMENTATION_KEY, null)) == null) break block18;
                if (org.apache.hadoop.fs.FileSystem.class.isAssignableFrom(classFromConfig)) {
                    fsClass = classFromConfig.asSubclass(org.apache.hadoop.fs.FileSystem.class);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Loaded HDFS class '" + fsClass.getName() + "' as specified in configuration."));
                    }
                    break block17;
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"HDFS class specified by fs.hdfs.impl is of wrong type.");
                    }
                    throw new IOException("HDFS class specified by fs.hdfs.impl cannot be cast to a FileSystem type.");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Trying to load default HDFS implementation org.apache.hadoop.hdfs.DistributedFileSystem");
            }
            try {
                Class<?> reflectedClass = Class.forName(DEFAULT_HDFS_CLASS);
                if (!org.apache.hadoop.fs.FileSystem.class.isAssignableFrom(reflectedClass)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Default HDFS class is of wrong type.");
                    }
                    throw new IOException("The default HDFS class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be cast to a FileSystem type.");
                }
                fsClass = reflectedClass.asSubclass(org.apache.hadoop.fs.FileSystem.class);
            }
            catch (ClassNotFoundException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Default HDFS class cannot be loaded.");
                }
                throw new IOException("No HDFS class has been configured and the default class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be loaded.");
            }
        }
        this.fs = this.instantiateFileSystem(fsClass);
    }

    public static Configuration getHadoopConfiguration() {
        Configuration retConf = new Configuration();
        String hdfsDefaultPath = GlobalConfiguration.getString((String)"fs.hdfs.hdfsdefault", null);
        if (hdfsDefaultPath != null) {
            retConf.addResource(new Path(hdfsDefaultPath));
        } else {
            LOG.debug((Object)"Cannot find hdfs-default configuration file");
        }
        String hdfsSitePath = GlobalConfiguration.getString((String)"fs.hdfs.hdfssite", null);
        if (hdfsSitePath != null) {
            retConf.addResource(new Path(hdfsSitePath));
        } else {
            LOG.debug((Object)"Cannot find hdfs-site configuration file");
        }
        String[] possibleHadoopConfPaths = new String[4];
        possibleHadoopConfPaths[0] = GlobalConfiguration.getString((String)"fs.hdfs.hadoopconf", null);
        possibleHadoopConfPaths[1] = System.getenv("HADOOP_CONF_DIR");
        if (System.getenv("HADOOP_HOME") != null) {
            possibleHadoopConfPaths[2] = System.getenv("HADOOP_HOME") + "/conf";
            possibleHadoopConfPaths[3] = System.getenv("HADOOP_HOME") + "/etc/hadoop";
        }
        for (int i = 0; i < possibleHadoopConfPaths.length; ++i) {
            if (possibleHadoopConfPaths[i] == null || !new File(possibleHadoopConfPaths[i]).exists()) continue;
            if (new File(possibleHadoopConfPaths[i] + "/core-site.xml").exists()) {
                retConf.addResource(new Path(possibleHadoopConfPaths[i] + "/core-site.xml"));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Adding " + possibleHadoopConfPaths[i] + "/core-site.xml to hadoop configuration"));
                }
            }
            if (!new File(possibleHadoopConfPaths[i] + "/hdfs-site.xml").exists()) continue;
            retConf.addResource(new Path(possibleHadoopConfPaths[i] + "/hdfs-site.xml"));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Adding " + possibleHadoopConfPaths[i] + "/hdfs-site.xml to hadoop configuration"));
        }
        return retConf;
    }

    private org.apache.hadoop.fs.FileSystem instantiateFileSystem(Class<? extends org.apache.hadoop.fs.FileSystem> fsClass) throws IOException {
        try {
            return fsClass.newInstance();
        }
        catch (ExceptionInInitializerError e) {
            throw new IOException("The filesystem class '" + fsClass.getName() + "' throw an exception upon initialization.", e.getException());
        }
        catch (Throwable t) {
            String errorMessage = InstantiationUtil.checkForInstantiationError(fsClass);
            if (errorMessage != null) {
                throw new IOException("The filesystem class '" + fsClass.getName() + "' cannot be instantiated: " + errorMessage);
            }
            throw new IOException("An error occurred while instantiating the filesystem class '" + fsClass.getName() + "'.", t);
        }
    }

    public eu.stratosphere.core.fs.Path getWorkingDirectory() {
        return new eu.stratosphere.core.fs.Path(this.fs.getWorkingDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public void initialize(URI path) throws IOException {
        block12: {
            if (path.getAuthority() == null) {
                String configEntry = this.conf.get("fs.default.name", null);
                if (configEntry == null) {
                    configEntry = this.conf.get("fs.defaultFS", null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("fs.defaultFS is set to " + configEntry));
                }
                if (configEntry == null) {
                    throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default hdfs configuration was registered, " + "or that configuration did not contain an entry for the default hdfs.");
                }
                try {
                    URI initURI = URI.create(configEntry);
                    if (initURI.getAuthority() == null) {
                        throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default hdfs configuration was registered, " + "or the provided configuration contains no valid hdfs namenode address (fs.default.name or fs.defaultFS) describing the hdfs namenode host and port.");
                    }
                    if (!initURI.getScheme().equalsIgnoreCase("hdfs")) {
                        throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default hdfs configuration was registered, " + "or the provided configuration describes a file system with scheme '" + initURI.getScheme() + "' other than the Hadoop Distributed File System (HDFS).");
                    }
                    try {
                        this.fs.initialize(initURI, this.conf);
                        break block12;
                    }
                    catch (Exception e) {
                        throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "Could not initialize the file system connection with the given address of the HDFS Namenode" + e.getMessage() != null ? ": " + e.getMessage() : ".", e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(DistributedFileSystem.getMissingAuthorityErrorPrefix(path) + "The configuration contains an invalid hdfs default name (fs.default.name or fs.defaultFS): " + configEntry);
                }
            }
            try {
                this.fs.initialize(path, this.conf);
            }
            catch (Exception e) {
                throw new IOException("The given file URI (" + path.toString() + ") described the host and port of an HDFS Namenode, but the File System could not be initialized with that address" + (e.getMessage() != null ? ": " + e.getMessage() : "."), e);
            }
        }
    }

    private static final String getMissingAuthorityErrorPrefix(URI path) {
        return "The given HDFS file URI (" + path.toString() + ") did not describe the HDFS Namenode." + " The attempt to use a default HDFS configuration, as specified in the '" + "fs.hdfs.hdfsdefault" + "' or '" + "fs.hdfs.hdfssite" + "' config parameter failed due to the following problem: ";
    }

    public FileStatus getFileStatus(eu.stratosphere.core.fs.Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(new Path(f.toString()));
        return new DistributedFileStatus(status);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof DistributedFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        DistributedFileStatus f = (DistributedFileStatus)file;
        org.apache.hadoop.fs.BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        BlockLocation[] distBlkLocations = new DistributedBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new DistributedBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public FSDataInputStream open(eu.stratosphere.core.fs.Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.FSDataInputStream fdis = this.fs.open(new Path(f.toString()), bufferSize);
        return new DistributedDataInputStream(fdis);
    }

    public FSDataInputStream open(eu.stratosphere.core.fs.Path f) throws IOException {
        org.apache.hadoop.fs.FSDataInputStream fdis = this.fs.open(new Path(f.toString()));
        return new DistributedDataInputStream(fdis);
    }

    public FSDataOutputStream create(eu.stratosphere.core.fs.Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        org.apache.hadoop.fs.FSDataOutputStream fdos = this.fs.create(new Path(f.toString()), overwrite, bufferSize, replication, blockSize);
        return new DistributedDataOutputStream(fdos);
    }

    public FSDataOutputStream create(eu.stratosphere.core.fs.Path f, boolean overwrite) throws IOException {
        org.apache.hadoop.fs.FSDataOutputStream fdos = this.fs.create(new Path(f.toString()), overwrite);
        return new DistributedDataOutputStream(fdos);
    }

    public boolean delete(eu.stratosphere.core.fs.Path f, boolean recursive) throws IOException {
        return this.fs.delete(new Path(f.toString()), recursive);
    }

    public FileStatus[] listStatus(eu.stratosphere.core.fs.Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(new Path(f.toString()));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new DistributedFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(eu.stratosphere.core.fs.Path f) throws IOException {
        return this.fs.mkdirs(new Path(f.toString()));
    }

    public boolean rename(eu.stratosphere.core.fs.Path src, eu.stratosphere.core.fs.Path dst) throws IOException {
        return this.fs.rename(new Path(src.toString()), new Path(dst.toString()));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }
}

