/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.runtime.fs;

import eu.stratosphere.core.fs.FSDataInputStream;
import java.io.IOException;

public class LineReader {
    private static final int CR = 13;
    private static final int LF = 10;
    private FSDataInputStream stream;
    private byte[] readBuffer;
    private byte[] wrapBuffer;
    private long lengthLeft;
    private int readPos;
    private int limit;
    private boolean overLimit;

    public LineReader(FSDataInputStream strm, long start, long length, int buffersize) throws IOException {
        this.stream = strm;
        this.readBuffer = new byte[buffersize];
        this.wrapBuffer = new byte[256];
        this.lengthLeft = length;
        this.readPos = 0;
        this.overLimit = false;
        if (start != 0L) {
            strm.seek(start);
            this.readLine();
        } else {
            this.fillBuffer();
        }
    }

    private final boolean fillBuffer() throws IOException {
        int read;
        int toRead;
        int n = toRead = this.lengthLeft > (long)this.readBuffer.length ? this.readBuffer.length : (int)this.lengthLeft;
        if (this.lengthLeft <= 0L) {
            toRead = this.readBuffer.length;
            this.overLimit = true;
        }
        if ((read = this.stream.read(this.readBuffer, 0, toRead)) == -1) {
            this.stream.close();
            this.stream = null;
            return false;
        }
        this.lengthLeft -= (long)read;
        this.readPos = 0;
        this.limit = read;
        return true;
    }

    public void close() throws IOException {
        this.wrapBuffer = null;
        this.readBuffer = null;
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public byte[] readLine() throws IOException {
        if (this.stream == null || this.overLimit) {
            return null;
        }
        int curr = 0;
        int countInWrapBuffer = 0;
        while (true) {
            if (this.readPos >= this.limit && !this.fillBuffer()) {
                if (countInWrapBuffer > 0) {
                    byte[] tmp = new byte[countInWrapBuffer];
                    System.arraycopy(this.wrapBuffer, 0, tmp, 0, countInWrapBuffer);
                    return tmp;
                }
                return null;
            }
            int startPos = this.readPos;
            int count = 0;
            while (this.readPos < this.limit && (curr = this.readBuffer[this.readPos++]) != 10) {
            }
            if (curr == 10) {
                byte[] end;
                count = this.readPos - startPos - 1;
                if (this.readPos == 1 && countInWrapBuffer > 0 && this.wrapBuffer[countInWrapBuffer - 1] == 13) {
                    --countInWrapBuffer;
                } else if (this.readPos > startPos + 1 && this.readBuffer[this.readPos - 2] == 13) {
                    --count;
                }
                if (countInWrapBuffer > 0) {
                    end = new byte[countInWrapBuffer + count];
                    System.arraycopy(this.wrapBuffer, 0, end, 0, countInWrapBuffer);
                    System.arraycopy(this.readBuffer, 0, end, countInWrapBuffer, count);
                    return end;
                }
                end = new byte[count];
                System.arraycopy(this.readBuffer, startPos, end, 0, count);
                return end;
            }
            count = this.limit - startPos;
            while (this.wrapBuffer.length - countInWrapBuffer < count) {
                byte[] tmp = new byte[this.wrapBuffer.length * 2];
                System.arraycopy(this.wrapBuffer, 0, tmp, 0, countInWrapBuffer);
                this.wrapBuffer = tmp;
            }
            System.arraycopy(this.readBuffer, startPos, this.wrapBuffer, countInWrapBuffer, count);
            countInWrapBuffer += count;
        }
    }
}

