/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.util;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MutableToRegularIteratorWrapper<T>
implements Iterator<T> {
    private final MutableObjectIterator<T> source;
    private T current;
    private T next;
    private boolean currentIsAvailable;

    public MutableToRegularIteratorWrapper(MutableObjectIterator<T> source, TypeSerializer<T> serializer) {
        this.source = source;
        this.current = serializer.createInstance();
        this.next = serializer.createInstance();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIsAvailable) {
            return true;
        }
        try {
            this.next = this.source.next(this.next);
            if (this.next != null) {
                T tmp = this.current;
                this.current = this.next;
                this.next = tmp;
                this.currentIsAvailable = true;
                return true;
            }
            return false;
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error reading next record: " + ioex.getMessage(), ioex);
        }
    }

    @Override
    public T next() {
        if (this.currentIsAvailable || this.hasNext()) {
            this.currentIsAvailable = false;
            return this.current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

