/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.util;

import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.IOException;

public final class KeyGroupedMutableObjectIterator<E> {
    private final MutableObjectIterator<E> iterator;
    private final TypeSerializer<E> serializer;
    private final TypeComparator<E> comparator;
    private E next;
    private ValuesIterator valuesIterator;
    private boolean nextIsFresh;

    public KeyGroupedMutableObjectIterator(MutableObjectIterator<E> iterator, TypeSerializer<E> serializer, TypeComparator<E> comparator) {
        if (iterator == null || serializer == null || comparator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.serializer = serializer;
        this.comparator = comparator;
    }

    public boolean nextKey() throws IOException {
        if (this.next == null) {
            this.next = this.serializer.createInstance();
            this.next = this.iterator.next(this.next);
            if (this.next != null) {
                this.comparator.setReference(this.next);
                this.nextIsFresh = false;
                this.valuesIterator = new ValuesIterator();
                this.valuesIterator.nextIsUnconsumed = true;
                return true;
            }
            this.valuesIterator = null;
            return false;
        }
        if (this.nextIsFresh) {
            this.nextIsFresh = false;
            this.comparator.setReference(this.next);
            this.valuesIterator.nextIsUnconsumed = true;
            return true;
        }
        while ((this.next = this.iterator.next(this.next)) != null) {
            if (this.comparator.equalToReference(this.next)) continue;
            this.comparator.setReference(this.next);
            this.nextIsFresh = false;
            this.valuesIterator.nextIsUnconsumed = true;
            return true;
        }
        this.valuesIterator = null;
        return false;
    }

    public MutableObjectIterator<E> getValues() {
        return this.valuesIterator;
    }

    private final class ValuesIterator
    implements MutableObjectIterator<E> {
        private final TypeSerializer<E> serializer;
        private final TypeComparator<E> comparator;
        private boolean nextIsUnconsumed;

        private ValuesIterator() {
            this.serializer = KeyGroupedMutableObjectIterator.this.serializer;
            this.comparator = KeyGroupedMutableObjectIterator.this.comparator;
            this.nextIsUnconsumed = false;
        }

        public E next(E target) {
            if (KeyGroupedMutableObjectIterator.this.next == null || KeyGroupedMutableObjectIterator.this.nextIsFresh) {
                return null;
            }
            if (this.nextIsUnconsumed) {
                return this.serializer.copy(KeyGroupedMutableObjectIterator.this.next, target);
            }
            try {
                target = KeyGroupedMutableObjectIterator.this.iterator.next(target);
                if (target != null) {
                    if (!this.comparator.equalToReference(target)) {
                        KeyGroupedMutableObjectIterator.this.next = this.serializer.copy(target, KeyGroupedMutableObjectIterator.this.next);
                        KeyGroupedMutableObjectIterator.this.nextIsFresh = true;
                        return null;
                    }
                    return target;
                }
                KeyGroupedMutableObjectIterator.this.next = null;
                return null;
            }
            catch (IOException ioex) {
                throw new RuntimeException("An error occurred while reading the next record: " + ioex.getMessage(), ioex);
            }
        }
    }
}

