/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.util;

import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class KeyGroupedIterator<E> {
    private final MutableObjectIterator<E> iterator;
    private final TypeSerializer<E> serializer;
    private final TypeComparator<E> comparator;
    private E current;
    private E lookahead;
    private ValuesIterator valuesIterator;
    private boolean lookAheadHasNext;
    private boolean done;

    public KeyGroupedIterator(MutableObjectIterator<E> iterator, TypeSerializer<E> serializer, TypeComparator<E> comparator) {
        if (iterator == null || serializer == null || comparator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.serializer = serializer;
        this.comparator = comparator;
    }

    public boolean nextKey() throws IOException {
        if (this.current == null) {
            if (this.done) {
                this.valuesIterator = null;
                return false;
            }
            this.current = this.serializer.createInstance();
            this.current = this.iterator.next(this.current);
            if (this.current != null) {
                this.comparator.setReference(this.current);
                this.lookAheadHasNext = false;
                this.valuesIterator = new ValuesIterator();
                this.valuesIterator.currentIsUnconsumed = true;
                return true;
            }
            this.valuesIterator = null;
            this.current = null;
            this.done = true;
            return false;
        }
        if (this.lookAheadHasNext) {
            this.lookAheadHasNext = false;
            this.current = this.lookahead;
            this.lookahead = null;
            this.comparator.setReference(this.current);
            this.valuesIterator.currentIsUnconsumed = true;
            return true;
        }
        while (!this.done && (this.current = this.iterator.next(this.current)) != null) {
            if (this.comparator.equalToReference(this.current)) continue;
            this.comparator.setReference(this.current);
            this.lookAheadHasNext = false;
            this.valuesIterator.currentIsUnconsumed = true;
            return true;
        }
        this.valuesIterator = null;
        this.current = null;
        this.done = true;
        return false;
    }

    public TypeComparator<E> getComparatorWithCurrentReference() {
        return this.comparator;
    }

    public E getCurrent() {
        return this.current;
    }

    public ValuesIterator getValues() {
        return this.valuesIterator;
    }

    public final class ValuesIterator
    implements Iterator<E> {
        private final TypeSerializer<E> serializer;
        private final TypeComparator<E> comparator;
        private E staging;
        private boolean currentIsUnconsumed;

        private ValuesIterator() {
            this.serializer = KeyGroupedIterator.this.serializer;
            this.comparator = KeyGroupedIterator.this.comparator;
            this.staging = this.serializer.createInstance();
            this.currentIsUnconsumed = false;
        }

        @Override
        public boolean hasNext() {
            if (KeyGroupedIterator.this.current == null || KeyGroupedIterator.this.lookAheadHasNext) {
                return false;
            }
            if (this.currentIsUnconsumed) {
                return true;
            }
            try {
                Object stagingStaging = KeyGroupedIterator.this.iterator.next(this.staging);
                if (stagingStaging != null) {
                    this.staging = stagingStaging;
                    if (this.comparator.equalToReference(this.staging)) {
                        Object tmp = this.staging;
                        this.staging = KeyGroupedIterator.this.current;
                        KeyGroupedIterator.this.current = tmp;
                        this.currentIsUnconsumed = true;
                        return true;
                    }
                    KeyGroupedIterator.this.lookAheadHasNext = true;
                    KeyGroupedIterator.this.lookahead = this.staging;
                    this.staging = KeyGroupedIterator.this.current;
                    return false;
                }
                KeyGroupedIterator.this.done = true;
                return false;
            }
            catch (IOException ioex) {
                throw new RuntimeException("An error occurred while reading the next record: " + ioex.getMessage(), ioex);
            }
        }

        @Override
        public E next() {
            if (this.currentIsUnconsumed || this.hasNext()) {
                this.currentIsUnconsumed = false;
                return KeyGroupedIterator.this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

