/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.udf;

import eu.stratosphere.api.common.accumulators.Accumulator;
import eu.stratosphere.api.common.accumulators.AccumulatorHelper;
import eu.stratosphere.api.common.accumulators.DoubleCounter;
import eu.stratosphere.api.common.accumulators.Histogram;
import eu.stratosphere.api.common.accumulators.IntCounter;
import eu.stratosphere.api.common.accumulators.LongCounter;
import eu.stratosphere.api.common.cache.DistributedCache;
import eu.stratosphere.api.common.functions.RuntimeContext;
import eu.stratosphere.core.fs.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.FutureTask;

public class RuntimeUDFContext
implements RuntimeContext {
    private final String name;
    private final int numParallelSubtasks;
    private final int subtaskIndex;
    private DistributedCache distributedCache = new DistributedCache();
    private HashMap<String, Accumulator<?, ?>> accumulators = new HashMap();
    private HashMap<String, Collection<?>> broadcastVars = new HashMap();

    public RuntimeUDFContext(String name, int numParallelSubtasks, int subtaskIndex) {
        this.name = name;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
    }

    public RuntimeUDFContext(String name, int numParallelSubtasks, int subtaskIndex, Map<String, FutureTask<Path>> cpTasks) {
        this.name = name;
        this.numParallelSubtasks = numParallelSubtasks;
        this.subtaskIndex = subtaskIndex;
        this.distributedCache.setCopyTasks(cpTasks);
    }

    public String getTaskName() {
        return this.name;
    }

    public int getNumberOfParallelSubtasks() {
        return this.numParallelSubtasks;
    }

    public int getIndexOfThisSubtask() {
        return this.subtaskIndex;
    }

    public IntCounter getIntCounter(String name) {
        return (IntCounter)this.getAccumulator(name, IntCounter.class);
    }

    public LongCounter getLongCounter(String name) {
        return (LongCounter)this.getAccumulator(name, LongCounter.class);
    }

    public Histogram getHistogram(String name) {
        return (Histogram)this.getAccumulator(name, Histogram.class);
    }

    public DoubleCounter getDoubleCounter(String name) {
        return (DoubleCounter)this.getAccumulator(name, DoubleCounter.class);
    }

    public <V, A> void addAccumulator(String name, Accumulator<V, A> accumulator) {
        if (this.accumulators.containsKey(name)) {
            throw new UnsupportedOperationException("The counter '" + name + "' already exists and cannot be added.");
        }
        this.accumulators.put(name, accumulator);
    }

    public <V, A> Accumulator<V, A> getAccumulator(String name) {
        return this.accumulators.get(name);
    }

    private <V, A> Accumulator<V, A> getAccumulator(String name, Class<? extends Accumulator<V, A>> accumulatorClass) {
        Object accumulator = this.accumulators.get(name);
        if (accumulator != null) {
            AccumulatorHelper.compareAccumulatorTypes((Object)name, accumulator.getClass(), accumulatorClass);
        } else {
            try {
                accumulator = accumulatorClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.accumulators.put(name, (Accumulator<?, ?>)accumulator);
        }
        return accumulator;
    }

    public HashMap<String, Accumulator<?, ?>> getAllAccumulators() {
        return this.accumulators;
    }

    public void setBroadcastVariable(String name, Collection<?> value) {
        this.broadcastVars.put(name, value);
    }

    public <RT> Collection<RT> getBroadcastVariable(String name) {
        if (!this.broadcastVars.containsKey(name)) {
            throw new IllegalArgumentException("Trying to access an unbound broadcast variable '" + name + "'.");
        }
        return this.broadcastVars.get(name);
    }

    public DistributedCache getDistributedCache() {
        return this.distributedCache;
    }
}

