/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task.chaining;

import eu.stratosphere.api.common.functions.Function;
import eu.stratosphere.api.common.functions.RuntimeContext;
import eu.stratosphere.nephele.execution.Environment;
import eu.stratosphere.nephele.template.AbstractInvokable;
import eu.stratosphere.pact.runtime.task.RegularPactTask;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.pact.runtime.udf.RuntimeUDFContext;
import eu.stratosphere.util.Collector;

public abstract class ChainedDriver<IT, OT>
implements Collector<IT> {
    protected TaskConfig config;
    protected String taskName;
    protected Collector<OT> outputCollector;
    protected ClassLoader userCodeClassLoader;
    private RuntimeUDFContext udfContext;

    public void setup(TaskConfig config, String taskName, Collector<OT> outputCollector, AbstractInvokable parent, ClassLoader userCodeClassLoader) {
        this.config = config;
        this.taskName = taskName;
        this.outputCollector = outputCollector;
        this.userCodeClassLoader = userCodeClassLoader;
        if (parent instanceof RegularPactTask) {
            this.udfContext = ((RegularPactTask)parent).createRuntimeContext(taskName);
        } else {
            Environment env = parent.getEnvironment();
            this.udfContext = new RuntimeUDFContext(taskName, env.getCurrentNumberOfSubtasks(), env.getIndexInSubtaskGroup(), env.getCopyTask());
        }
        this.setup(parent);
    }

    public abstract void setup(AbstractInvokable var1);

    public abstract void openTask() throws Exception;

    public abstract void closeTask() throws Exception;

    public abstract void cancelTask();

    public abstract Function getStub();

    public abstract String getTaskName();

    public abstract void collect(IT var1);

    protected RuntimeContext getUdfRuntimeContext() {
        return this.udfContext;
    }

    public void setOutputCollector(Collector<?> outputCollector) {
        this.outputCollector = outputCollector;
    }

    public Collector<OT> getOutputCollector() {
        return this.outputCollector;
    }

    public TaskConfig getTaskConfig() {
        return this.config;
    }
}

