/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericReduce;
import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.util.Collector;
import eu.stratosphere.util.MutableObjectIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReduceDriver<T>
implements PactDriver<GenericReduce<T>, T> {
    private static final Log LOG = LogFactory.getLog(ReduceDriver.class);
    private PactTaskContext<GenericReduce<T>, T> taskContext;
    private MutableObjectIterator<T> input;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private volatile boolean running;

    @Override
    public void setup(PactTaskContext<GenericReduce<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GenericReduce<T>> getStubType() {
        Class<GenericReduce> clazz = GenericReduce.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.SORTED_REDUCE) {
            throw new Exception("Unrecognized driver strategy for Reduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.comparator = this.taskContext.getInputComparator(0);
        this.input = this.taskContext.getInput(0);
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("Reducer preprocessing done. Running Reducer code."));
        }
        MutableObjectIterator<T> input = this.input;
        TypeSerializer<T> serializer = this.serializer;
        TypeComparator<T> comparator = this.comparator;
        GenericReduce<T> function = this.taskContext.getStub();
        Collector<T> output = this.taskContext.getOutputCollector();
        Object value = input.next(serializer.createInstance());
        while (this.running && value != null) {
            comparator.setReference(value);
            Object res = value;
            while ((value = input.next(serializer.createInstance())) != null && comparator.equalToReference(value)) {
                res = function.reduce(res, value);
            }
            output.collect(res);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

