/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericReduce;
import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.api.common.typeutils.TypeSerializerFactory;
import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.memorymanager.MemoryManager;
import eu.stratosphere.pact.runtime.sort.FixedLengthRecordSorter;
import eu.stratosphere.pact.runtime.sort.InMemorySorter;
import eu.stratosphere.pact.runtime.sort.NormalizedKeySorter;
import eu.stratosphere.pact.runtime.sort.QuickSort;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.util.Collector;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReduceCombineDriver<T>
implements PactDriver<GenericReduce<T>, T> {
    private static final Log LOG = LogFactory.getLog(ReduceCombineDriver.class);
    private static final int THRESHOLD_FOR_IN_PLACE_SORTING = 32;
    private PactTaskContext<GenericReduce<T>, T> taskContext;
    private TypeSerializer<T> serializer;
    private TypeComparator<T> comparator;
    private GenericReduce<T> reducer;
    private Collector<T> output;
    private MemoryManager memManager;
    private InMemorySorter<T> sorter;
    private QuickSort sortAlgo = new QuickSort();
    private boolean running;

    @Override
    public void setup(PactTaskContext<GenericReduce<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GenericReduce<T>> getStubType() {
        Class<GenericReduce> clazz = GenericReduce.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        if (this.taskContext.getTaskConfig().getDriverStrategy() != DriverStrategy.SORTED_PARTIAL_REDUCE) {
            throw new Exception("Invalid strategy " + (Object)((Object)this.taskContext.getTaskConfig().getDriverStrategy()) + " for reduce combiner.");
        }
        this.memManager = this.taskContext.getMemoryManager();
        int numMemoryPages = this.memManager.computeNumberOfPages(this.taskContext.getTaskConfig().getRelativeMemoryDriver());
        TypeSerializerFactory serializerFactory = this.taskContext.getInputSerializer(0);
        this.serializer = serializerFactory.getSerializer();
        this.comparator = this.taskContext.getInputComparator(0);
        this.serializer = serializerFactory.getSerializer();
        this.reducer = this.taskContext.getStub();
        this.output = this.taskContext.getOutputCollector();
        List<MemorySegment> memory = this.memManager.allocatePages(this.taskContext.getOwningNepheleTask(), numMemoryPages);
        this.sorter = this.comparator.supportsSerializationWithKeyNormalization() && this.serializer.getLength() > 0 && this.serializer.getLength() <= 32 ? new FixedLengthRecordSorter<T>(this.serializer, this.comparator, memory) : new NormalizedKeySorter<T>(this.serializer, this.comparator.duplicate(), memory);
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Combiner starting.");
        }
        MutableObjectIterator in = this.taskContext.getInput(0);
        TypeSerializer<T> serializer = this.serializer;
        Object value = serializer.createInstance();
        while (this.running && (value = in.next(value)) != null) {
            if (this.sorter.write(value)) continue;
            this.sortAndCombine();
            this.sorter.reset();
            if (this.sorter.write(value)) continue;
            throw new IOException("Cannot write record to fresh sort buffer. Record too large.");
        }
        this.sortAndCombine();
    }

    private void sortAndCombine() throws Exception {
        InMemorySorter<T> sorter = this.sorter;
        if (!sorter.isEmpty()) {
            this.sortAlgo.sort(sorter);
            TypeSerializer<T> serializer = this.serializer;
            TypeComparator<T> comparator = this.comparator;
            GenericReduce<T> function = this.reducer;
            Collector<T> output = this.output;
            MutableObjectIterator<T> input = sorter.getIterator();
            Object value = input.next(serializer.createInstance());
            while (this.running && value != null) {
                comparator.setReference(value);
                Object res = value;
                while ((value = input.next(serializer.createInstance())) != null && comparator.equalToReference(value)) {
                    res = function.reduce(res, value);
                }
                output.collect(res);
            }
        }
    }

    @Override
    public void cleanup() {
        this.memManager.release(this.sorter.dispose());
    }

    @Override
    public void cancel() {
        this.running = false;
        this.memManager.release(this.sorter.dispose());
    }
}

