/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericJoiner;
import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypePairComparatorFactory;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.nephele.services.iomanager.IOManager;
import eu.stratosphere.nephele.services.memorymanager.MemoryManager;
import eu.stratosphere.pact.runtime.hash.BuildFirstHashMatchIterator;
import eu.stratosphere.pact.runtime.hash.BuildSecondHashMatchIterator;
import eu.stratosphere.pact.runtime.sort.MergeMatchIterator;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.pact.runtime.task.util.JoinTaskIterator;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.util.Collector;
import eu.stratosphere.util.MutableObjectIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatchDriver<IT1, IT2, OT>
implements PactDriver<GenericJoiner<IT1, IT2, OT>, OT> {
    protected static final Log LOG = LogFactory.getLog(MatchDriver.class);
    protected PactTaskContext<GenericJoiner<IT1, IT2, OT>, OT> taskContext;
    private volatile JoinTaskIterator<IT1, IT2, OT> matchIterator;
    protected volatile boolean running;

    @Override
    public void setup(PactTaskContext<GenericJoiner<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 2;
    }

    @Override
    public Class<GenericJoiner<IT1, IT2, OT>> getStubType() {
        Class<GenericJoiner> clazz = GenericJoiner.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        MemoryManager memoryManager = this.taskContext.getMemoryManager();
        IOManager ioManager = this.taskContext.getIOManager();
        double fractionAvailableMemory = config.getRelativeMemoryDriver();
        int numPages = memoryManager.computeNumberOfPages(fractionAvailableMemory);
        DriverStrategy ls = config.getDriverStrategy();
        MutableObjectIterator in1 = this.taskContext.getInput(0);
        MutableObjectIterator in2 = this.taskContext.getInput(1);
        TypeSerializer serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
        TypeSerializer serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
        TypeComparator comparator1 = this.taskContext.getInputComparator(0);
        TypeComparator comparator2 = this.taskContext.getInputComparator(1);
        TypePairComparatorFactory pairComparatorFactory = config.getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        if (pairComparatorFactory == null) {
            throw new Exception("Missing pair comparator factory for Match driver");
        }
        switch (ls) {
            case MERGE: {
                this.matchIterator = new MergeMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, numPages, this.taskContext.getOwningNepheleTask());
                break;
            }
            case HYBRIDHASH_BUILD_FIRST: {
                this.matchIterator = new BuildFirstHashMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory);
                break;
            }
            case HYBRIDHASH_BUILD_SECOND: {
                this.matchIterator = new BuildSecondHashMatchIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory);
                break;
            }
            default: {
                throw new Exception("Unsupported driver strategy for Match driver: " + ls.name());
            }
        }
        this.matchIterator.open();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("Match task iterator ready."));
        }
    }

    @Override
    public void run() throws Exception {
        GenericJoiner<IT1, IT2, OT> matchStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        JoinTaskIterator<IT1, IT2, OT> matchIterator = this.matchIterator;
        while (this.running && matchIterator.callWithNextKey(matchStub, collector)) {
        }
    }

    @Override
    public void cleanup() throws Exception {
        if (this.matchIterator != null) {
            this.matchIterator.close();
            this.matchIterator = null;
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        if (this.matchIterator != null) {
            this.matchIterator.abort();
        }
    }
}

