/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericGroupReduce;
import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.pact.runtime.util.KeyGroupedIterator;
import eu.stratosphere.util.Collector;
import eu.stratosphere.util.MutableObjectIterator;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupReduceDriver<IT, OT>
implements PactDriver<GenericGroupReduce<IT, OT>, OT> {
    private static final Log LOG = LogFactory.getLog(GroupReduceDriver.class);
    private PactTaskContext<GenericGroupReduce<IT, OT>, OT> taskContext;
    private MutableObjectIterator<IT> input;
    private TypeSerializer<IT> serializer;
    private TypeComparator<IT> comparator;
    private volatile boolean running;

    @Override
    public void setup(PactTaskContext<GenericGroupReduce<IT, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GenericGroupReduce<IT, OT>> getStubType() {
        Class<GenericGroupReduce> clazz = GenericGroupReduce.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.SORTED_GROUP_REDUCE) {
            throw new Exception("Unrecognized driver strategy for GroupReduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.comparator = this.taskContext.getInputComparator(0);
        this.input = this.taskContext.getInput(0);
    }

    @Override
    public void run() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("GroupReducer preprocessing done. Running GroupReducer code."));
        }
        KeyGroupedIterator<IT> iter = new KeyGroupedIterator<IT>(this.input, this.serializer, this.comparator);
        GenericGroupReduce<IT, OT> stub = this.taskContext.getStub();
        Collector<OT> output = this.taskContext.getOutputCollector();
        while (this.running && iter.nextKey()) {
            stub.reduce((Iterator)iter.getValues(), output);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

