/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.pact.runtime.task.AllGroupReduceDriver;
import eu.stratosphere.pact.runtime.task.AllReduceDriver;
import eu.stratosphere.pact.runtime.task.BuildFirstCachedMatchDriver;
import eu.stratosphere.pact.runtime.task.BuildSecondCachedMatchDriver;
import eu.stratosphere.pact.runtime.task.CoGroupDriver;
import eu.stratosphere.pact.runtime.task.CollectorMapDriver;
import eu.stratosphere.pact.runtime.task.CrossDriver;
import eu.stratosphere.pact.runtime.task.DamBehavior;
import eu.stratosphere.pact.runtime.task.FlatMapDriver;
import eu.stratosphere.pact.runtime.task.GroupReduceCombineDriver;
import eu.stratosphere.pact.runtime.task.GroupReduceDriver;
import eu.stratosphere.pact.runtime.task.MapDriver;
import eu.stratosphere.pact.runtime.task.MatchDriver;
import eu.stratosphere.pact.runtime.task.NoOpDriver;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.ReduceCombineDriver;
import eu.stratosphere.pact.runtime.task.ReduceDriver;
import eu.stratosphere.pact.runtime.task.chaining.ChainedCollectorMapDriver;
import eu.stratosphere.pact.runtime.task.chaining.ChainedDriver;
import eu.stratosphere.pact.runtime.task.chaining.ChainedFlatMapDriver;
import eu.stratosphere.pact.runtime.task.chaining.ChainedMapDriver;
import eu.stratosphere.pact.runtime.task.chaining.SynchronousChainedCombineDriver;

public enum DriverStrategy {
    NONE(null, null, DamBehavior.PIPELINED, false),
    UNARY_NO_OP(NoOpDriver.class, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, false),
    BINARY_NO_OP(null, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, false),
    COLLECTOR_MAP(CollectorMapDriver.class, ChainedCollectorMapDriver.class, DamBehavior.PIPELINED, false),
    MAP(MapDriver.class, ChainedMapDriver.class, DamBehavior.PIPELINED, false),
    FLAT_MAP(FlatMapDriver.class, ChainedFlatMapDriver.class, DamBehavior.PIPELINED, false),
    ALL_REDUCE(AllReduceDriver.class, null, DamBehavior.PIPELINED, false),
    ALL_GROUP_REDUCE(AllGroupReduceDriver.class, null, DamBehavior.PIPELINED, false),
    ALL_GROUP_COMBINE(AllGroupReduceDriver.class, null, DamBehavior.PIPELINED, false),
    SORTED_REDUCE(ReduceDriver.class, null, DamBehavior.PIPELINED, true),
    SORTED_PARTIAL_REDUCE(ReduceCombineDriver.class, null, DamBehavior.MATERIALIZING, true),
    SORTED_GROUP_REDUCE(GroupReduceDriver.class, null, DamBehavior.PIPELINED, true),
    SORTED_GROUP_COMBINE(GroupReduceCombineDriver.class, SynchronousChainedCombineDriver.class, DamBehavior.MATERIALIZING, true),
    MERGE(MatchDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.MATERIALIZING, true),
    CO_GROUP(CoGroupDriver.class, null, DamBehavior.PIPELINED, DamBehavior.PIPELINED, true),
    HYBRIDHASH_BUILD_FIRST(MatchDriver.class, null, DamBehavior.FULL_DAM, DamBehavior.MATERIALIZING, true),
    HYBRIDHASH_BUILD_SECOND(MatchDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.FULL_DAM, true),
    HYBRIDHASH_BUILD_FIRST_CACHED(BuildFirstCachedMatchDriver.class, null, DamBehavior.FULL_DAM, DamBehavior.MATERIALIZING, true),
    HYBRIDHASH_BUILD_SECOND_CACHED(BuildSecondCachedMatchDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.FULL_DAM, true),
    NESTEDLOOP_BLOCKED_OUTER_FIRST(CrossDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.MATERIALIZING, false),
    NESTEDLOOP_BLOCKED_OUTER_SECOND(CrossDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.MATERIALIZING, false),
    NESTEDLOOP_STREAMED_OUTER_FIRST(CrossDriver.class, null, DamBehavior.PIPELINED, DamBehavior.MATERIALIZING, false),
    NESTEDLOOP_STREAMED_OUTER_SECOND(CrossDriver.class, null, DamBehavior.MATERIALIZING, DamBehavior.PIPELINED, false),
    UNION(null, null, DamBehavior.FULL_DAM, DamBehavior.FULL_DAM, false);

    private final Class<? extends PactDriver<?, ?>> driverClass;
    private final Class<? extends ChainedDriver<?, ?>> pushChainDriver;
    private final DamBehavior dam1;
    private final DamBehavior dam2;
    private final int numInputs;
    private final boolean requiresComparator;

    private DriverStrategy(Class<? extends PactDriver> driverClass, Class<? extends ChainedDriver> pushChainDriverClass, DamBehavior dam, boolean comparator) {
        this.driverClass = driverClass;
        this.pushChainDriver = pushChainDriverClass;
        this.numInputs = 1;
        this.dam1 = dam;
        this.dam2 = null;
        this.requiresComparator = comparator;
    }

    private DriverStrategy(Class<? extends PactDriver> driverClass, Class<? extends ChainedDriver> pushChainDriverClass, DamBehavior firstDam, DamBehavior secondDam, boolean comparator) {
        this.driverClass = driverClass;
        this.pushChainDriver = pushChainDriverClass;
        this.numInputs = 2;
        this.dam1 = firstDam;
        this.dam2 = secondDam;
        this.requiresComparator = comparator;
    }

    public Class<? extends PactDriver<?, ?>> getDriverClass() {
        return this.driverClass;
    }

    public Class<? extends ChainedDriver<?, ?>> getPushChainDriverClass() {
        return this.pushChainDriver;
    }

    public int getNumInputs() {
        return this.numInputs;
    }

    public DamBehavior firstDam() {
        return this.dam1;
    }

    public DamBehavior secondDam() {
        if (this.numInputs == 2) {
            return this.dam2;
        }
        throw new IllegalArgumentException("The given strategy does not work on two inputs.");
    }

    public DamBehavior damOnInput(int num) {
        if (num < this.numInputs) {
            if (num == 0) {
                return this.dam1;
            }
            if (num == 1) {
                return this.dam2;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isMaterializing() {
        return this.dam1.isMaterializing() || this.dam2 != null && this.dam2.isMaterializing();
    }

    public boolean requiresComparator() {
        return this.requiresComparator;
    }
}

