/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericCoGrouper;
import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypePairComparator;
import eu.stratosphere.api.common.typeutils.TypePairComparatorFactory;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.hash.AbstractHashTableProber;
import eu.stratosphere.pact.runtime.hash.CompactingHashTable;
import eu.stratosphere.pact.runtime.iterative.concurrent.SolutionSetBroker;
import eu.stratosphere.pact.runtime.iterative.task.AbstractIterativePactTask;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.pact.runtime.task.ResettablePactDriver;
import eu.stratosphere.pact.runtime.util.EmptyIterator;
import eu.stratosphere.pact.runtime.util.KeyGroupedIterator;
import eu.stratosphere.pact.runtime.util.SingleElementIterator;
import eu.stratosphere.util.Collector;
import java.util.Iterator;

public class CoGroupWithSolutionSetFirstDriver<IT1, IT2, OT>
implements ResettablePactDriver<GenericCoGrouper<IT1, IT2, OT>, OT> {
    private PactTaskContext<GenericCoGrouper<IT1, IT2, OT>, OT> taskContext;
    private CompactingHashTable<IT1> hashTable;
    private TypeSerializer<IT2> probeSideSerializer;
    private TypeComparator<IT2> probeSideComparator;
    private TypePairComparator<IT2, IT1> pairComparator;
    private IT1 solutionSideRecord;
    protected volatile boolean running;

    @Override
    public void setup(PactTaskContext<GenericCoGrouper<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GenericCoGrouper<IT1, IT2, OT>> getStubType() {
        Class<GenericCoGrouper> clazz = GenericCoGrouper.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    @Override
    public void initialize() {
        if (!(this.taskContext instanceof AbstractIterativePactTask)) {
            throw new RuntimeException("The task context of this driver is no iterative task context.");
        }
        AbstractIterativePactTask iterativeTaskContext = (AbstractIterativePactTask)this.taskContext;
        String identifier = iterativeTaskContext.brokerKey();
        this.hashTable = SolutionSetBroker.instance().get(identifier);
        TypeSerializer buildSideSerializer = this.hashTable.getBuildSideSerializer();
        TypeComparator buildSideComparator = this.hashTable.getBuildSideComparator().duplicate();
        this.probeSideSerializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.probeSideComparator = this.taskContext.getInputComparator(0);
        this.solutionSideRecord = buildSideSerializer.createInstance();
        TypePairComparatorFactory pairCompFactory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        this.pairComparator = pairCompFactory.createComparator21(buildSideComparator, this.probeSideComparator);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        GenericCoGrouper<IT1, IT2, OT> coGroupStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        IT1 buildSideRecord = this.solutionSideRecord;
        CompactingHashTable<IT1> join = this.hashTable;
        KeyGroupedIterator probeSideInput = new KeyGroupedIterator(this.taskContext.getInput(0), this.probeSideSerializer, this.probeSideComparator);
        SingleElementIterator<IT1> siIter = new SingleElementIterator<IT1>();
        Iterator emptySolutionSide = EmptyIterator.get();
        AbstractHashTableProber prober = join.getProber((TypeComparator)this.probeSideComparator, (TypePairComparator)this.pairComparator);
        while (this.running && probeSideInput.nextKey()) {
            Object current = probeSideInput.getCurrent();
            if (((CompactingHashTable.HashTableProber)prober).getMatchFor(current, buildSideRecord)) {
                siIter.set(buildSideRecord);
                coGroupStub.coGroup(siIter, (Iterator)probeSideInput.getValues(), collector);
                continue;
            }
            coGroupStub.coGroup(emptySolutionSide, (Iterator)probeSideInput.getValues(), collector);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

