/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericCoGrouper;
import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypePairComparatorFactory;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.sort.SortMergeCoGroupIterator;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.pact.runtime.task.util.CoGroupTaskIterator;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.util.Collector;
import eu.stratosphere.util.MutableObjectIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoGroupDriver<IT1, IT2, OT>
implements PactDriver<GenericCoGrouper<IT1, IT2, OT>, OT> {
    private static final Log LOG = LogFactory.getLog(CoGroupDriver.class);
    private PactTaskContext<GenericCoGrouper<IT1, IT2, OT>, OT> taskContext;
    private CoGroupTaskIterator<IT1, IT2> coGroupIterator;
    private volatile boolean running;

    @Override
    public void setup(PactTaskContext<GenericCoGrouper<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 2;
    }

    @Override
    public Class<GenericCoGrouper<IT1, IT2, OT>> getStubType() {
        Class<GenericCoGrouper> clazz = GenericCoGrouper.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return true;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.CO_GROUP) {
            throw new Exception("Unrecognized driver strategy for CoGoup driver: " + config.getDriverStrategy().name());
        }
        MutableObjectIterator in1 = this.taskContext.getInput(0);
        MutableObjectIterator in2 = this.taskContext.getInput(1);
        TypeSerializer serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
        TypeSerializer serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
        TypeComparator groupComparator1 = this.taskContext.getInputComparator(0);
        TypeComparator groupComparator2 = this.taskContext.getInputComparator(1);
        TypePairComparatorFactory pairComparatorFactory = config.getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        if (pairComparatorFactory == null) {
            throw new Exception("Missing pair comparator factory for CoGroup driver");
        }
        this.coGroupIterator = new SortMergeCoGroupIterator(in1, in2, serializer1, groupComparator1, serializer2, groupComparator2, pairComparatorFactory.createComparator12(groupComparator1, groupComparator2));
        this.coGroupIterator.open();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("CoGroup task iterator ready."));
        }
    }

    @Override
    public void run() throws Exception {
        GenericCoGrouper<IT1, IT2, OT> coGroupStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        CoGroupTaskIterator<IT1, IT2> coGroupIterator = this.coGroupIterator;
        while (this.running && coGroupIterator.next()) {
            coGroupStub.coGroup(coGroupIterator.getValues1(), coGroupIterator.getValues2(), collector);
        }
    }

    @Override
    public void cleanup() throws Exception {
        if (this.coGroupIterator != null) {
            this.coGroupIterator.close();
            this.coGroupIterator = null;
        }
    }

    @Override
    public void cancel() throws Exception {
        this.running = false;
        this.cleanup();
    }
}

