/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericReduce;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.api.common.typeutils.TypeSerializerFactory;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.util.MutableObjectIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllReduceDriver<T>
implements PactDriver<GenericReduce<T>, T> {
    private static final Log LOG = LogFactory.getLog(AllReduceDriver.class);
    private PactTaskContext<GenericReduce<T>, T> taskContext;
    private MutableObjectIterator<T> input;
    private TypeSerializer<T> serializer;
    private boolean running;

    @Override
    public void setup(PactTaskContext<GenericReduce<T>, T> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GenericReduce<T>> getStubType() {
        Class<GenericReduce> clazz = GenericReduce.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return false;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        if (config.getDriverStrategy() != DriverStrategy.ALL_REDUCE) {
            throw new Exception("Unrecognized driver strategy for AllReduce driver: " + config.getDriverStrategy().name());
        }
        TypeSerializerFactory serializerFactory = this.taskContext.getInputSerializer(0);
        this.serializer = serializerFactory.getSerializer();
        this.input = this.taskContext.getInput(0);
    }

    @Override
    public void run() throws Exception {
        Object val2;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("AllReduce preprocessing done. Running Reducer code."));
        }
        GenericReduce<T> stub = this.taskContext.getStub();
        MutableObjectIterator<T> input = this.input;
        TypeSerializer<T> serializer = this.serializer;
        Object val1 = serializer.createInstance();
        if ((val1 = input.next(val1)) == null) {
            return;
        }
        while (this.running && (val2 = input.next(serializer.createInstance())) != null) {
            val1 = stub.reduce(val1, val2);
        }
        this.taskContext.getOutputCollector().collect(val1);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

