/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.task;

import eu.stratosphere.api.common.functions.GenericCombine;
import eu.stratosphere.api.common.functions.GenericGroupReduce;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.task.DriverStrategy;
import eu.stratosphere.pact.runtime.task.PactDriver;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.pact.runtime.task.util.TaskConfig;
import eu.stratosphere.pact.runtime.util.MutableToRegularIteratorWrapper;
import eu.stratosphere.util.Collector;
import eu.stratosphere.util.MutableObjectIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllGroupReduceDriver<IT, OT>
implements PactDriver<GenericGroupReduce<IT, OT>, OT> {
    private static final Log LOG = LogFactory.getLog(AllGroupReduceDriver.class);
    private PactTaskContext<GenericGroupReduce<IT, OT>, OT> taskContext;
    private MutableObjectIterator<IT> input;
    private TypeSerializer<IT> serializer;
    private DriverStrategy strategy;

    @Override
    public void setup(PactTaskContext<GenericGroupReduce<IT, OT>, OT> context) {
        this.taskContext = context;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<GenericGroupReduce<IT, OT>> getStubType() {
        Class<GenericGroupReduce> clazz = GenericGroupReduce.class;
        return clazz;
    }

    @Override
    public boolean requiresComparatorOnInput() {
        return false;
    }

    @Override
    public void prepare() throws Exception {
        TaskConfig config = this.taskContext.getTaskConfig();
        this.strategy = config.getDriverStrategy();
        if (this.strategy == DriverStrategy.ALL_GROUP_COMBINE) {
            if (!(this.taskContext.getStub() instanceof GenericCombine)) {
                throw new Exception("Using combiner on a UDF that does not implement the combiner interface " + GenericCombine.class.getName());
            }
        } else if (this.strategy != DriverStrategy.ALL_GROUP_REDUCE) {
            throw new Exception("Unrecognized driver strategy for AllGroupReduce driver: " + config.getDriverStrategy().name());
        }
        this.serializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.input = this.taskContext.getInput(0);
    }

    @Override
    public void run() throws Exception {
        MutableToRegularIteratorWrapper<IT> inIter;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)this.taskContext.formatLogString("AllGroupReduce preprocessing done. Running Reducer code."));
        }
        if ((inIter = new MutableToRegularIteratorWrapper<IT>(this.input, this.serializer)).hasNext()) {
            if (this.strategy == DriverStrategy.ALL_GROUP_REDUCE) {
                GenericGroupReduce<IT, OT> reducer = this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                reducer.reduce(inIter, output);
            } else {
                GenericCombine combiner = (GenericCombine)this.taskContext.getStub();
                Collector<OT> output = this.taskContext.getOutputCollector();
                combiner.combine(inIter, output);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void cancel() {
    }
}

