/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.sort;

import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.iomanager.ChannelWriterOutputView;
import eu.stratosphere.nephele.services.memorymanager.ListMemorySegmentSource;
import eu.stratosphere.pact.runtime.io.RandomAccessInputView;
import eu.stratosphere.pact.runtime.io.SimpleCollectingOutputView;
import eu.stratosphere.pact.runtime.sort.InMemorySorter;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class NormalizedKeySorter<T>
implements InMemorySorter<T> {
    private static final int OFFSET_LEN = 8;
    private static final int DEFAULT_MAX_NORMALIZED_KEY_LEN = 8;
    private static final int MIN_REQUIRED_BUFFERS = 3;
    private final byte[] swapBuffer;
    private final TypeSerializer<T> serializer;
    private final TypeComparator<T> comparator;
    private final SimpleCollectingOutputView recordCollector;
    private final RandomAccessInputView recordBuffer;
    private final RandomAccessInputView recordBufferForComparison;
    private MemorySegment currentSortIndexSegment;
    private final ArrayList<MemorySegment> freeMemory;
    private final ArrayList<MemorySegment> sortIndex;
    private final ArrayList<MemorySegment> recordBufferSegments;
    private long currentDataBufferOffset;
    private long sortIndexBytes;
    private int currentSortIndexOffset;
    private int numRecords;
    private final int numKeyBytes;
    private final int indexEntrySize;
    private final int indexEntriesPerSegment;
    private final int lastIndexEntryOffset;
    private final int segmentSize;
    private final int totalNumBuffers;
    private final boolean normalizedKeyFullyDetermines;
    private final boolean useNormKeyUninverted;

    public NormalizedKeySorter(TypeSerializer<T> serializer, TypeComparator<T> comparator, List<MemorySegment> memory) {
        this(serializer, comparator, memory, 8);
    }

    public NormalizedKeySorter(TypeSerializer<T> serializer, TypeComparator<T> comparator, List<MemorySegment> memory, int maxNormalizedKeyBytes) {
        if (serializer == null || comparator == null || memory == null) {
            throw new NullPointerException();
        }
        if (maxNormalizedKeyBytes < 0) {
            throw new IllegalArgumentException("Maximal number of normalized key bytes must not be negative.");
        }
        this.serializer = serializer;
        this.comparator = comparator;
        this.useNormKeyUninverted = !comparator.invertNormalizedKey();
        this.totalNumBuffers = memory.size();
        if (this.totalNumBuffers < 3) {
            throw new IllegalArgumentException("Normalized-Key sorter requires at least 3 memory buffers.");
        }
        this.segmentSize = memory.get(0).size();
        if (memory instanceof ArrayList) {
            this.freeMemory = (ArrayList)memory;
        } else {
            this.freeMemory = new ArrayList(memory.size());
            this.freeMemory.addAll(memory);
        }
        this.sortIndex = new ArrayList(16);
        this.recordBufferSegments = new ArrayList(16);
        this.recordCollector = new SimpleCollectingOutputView(this.recordBufferSegments, new ListMemorySegmentSource(this.freeMemory), this.segmentSize);
        this.recordBuffer = new RandomAccessInputView(this.recordBufferSegments, this.segmentSize);
        this.recordBufferForComparison = new RandomAccessInputView(this.recordBufferSegments, this.segmentSize);
        if (this.comparator.supportsNormalizedKey()) {
            this.numKeyBytes = Math.min(this.comparator.getNormalizeKeyLen(), maxNormalizedKeyBytes);
            this.normalizedKeyFullyDetermines = !this.comparator.isNormalizedKeyPrefixOnly(this.numKeyBytes);
        } else {
            this.numKeyBytes = 0;
            this.normalizedKeyFullyDetermines = false;
        }
        this.indexEntrySize = this.numKeyBytes + 8;
        this.indexEntriesPerSegment = this.segmentSize / this.indexEntrySize;
        this.lastIndexEntryOffset = (this.indexEntriesPerSegment - 1) * this.indexEntrySize;
        this.swapBuffer = new byte[this.indexEntrySize];
        this.currentSortIndexSegment = this.nextMemorySegment();
        this.sortIndex.add(this.currentSortIndexSegment);
    }

    @Override
    public void reset() {
        this.numRecords = 0;
        this.currentSortIndexOffset = 0;
        this.currentDataBufferOffset = 0L;
        this.sortIndexBytes = 0L;
        this.freeMemory.addAll(this.sortIndex);
        this.freeMemory.addAll(this.recordBufferSegments);
        this.sortIndex.clear();
        this.recordBufferSegments.clear();
        this.currentSortIndexSegment = this.nextMemorySegment();
        this.sortIndex.add(this.currentSortIndexSegment);
        this.recordCollector.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.numRecords == 0;
    }

    @Override
    public List<MemorySegment> dispose() {
        this.freeMemory.addAll(this.sortIndex);
        this.freeMemory.addAll(this.recordBufferSegments);
        this.recordBufferSegments.clear();
        this.sortIndex.clear();
        return this.freeMemory;
    }

    @Override
    public long getCapacity() {
        return (long)this.totalNumBuffers * (long)this.segmentSize;
    }

    @Override
    public long getOccupancy() {
        return this.currentDataBufferOffset + this.sortIndexBytes;
    }

    @Override
    public T getRecord(T reuse, int logicalPosition) throws IOException {
        return this.getRecordFromBuffer(reuse, this.readPointer(logicalPosition));
    }

    @Override
    public boolean write(T record) throws IOException {
        if (this.currentSortIndexOffset > this.lastIndexEntryOffset) {
            if (this.memoryAvailable()) {
                this.currentSortIndexSegment = this.nextMemorySegment();
                this.sortIndex.add(this.currentSortIndexSegment);
                this.currentSortIndexOffset = 0;
                this.sortIndexBytes += (long)this.segmentSize;
            } else {
                return false;
            }
        }
        this.currentSortIndexSegment.putLong(this.currentSortIndexOffset, this.currentDataBufferOffset);
        if (this.numKeyBytes != 0) {
            this.comparator.putNormalizedKey(record, this.currentSortIndexSegment, this.currentSortIndexOffset + 8, this.numKeyBytes);
        }
        try {
            this.serializer.serialize(record, (DataOutputView)this.recordCollector);
            this.currentSortIndexOffset += this.indexEntrySize;
            this.currentDataBufferOffset = this.recordCollector.getCurrentOffset();
            ++this.numRecords;
            return true;
        }
        catch (EOFException eofex) {
            return false;
        }
    }

    private final long readPointer(int logicalPosition) {
        if (logicalPosition < 0 | logicalPosition >= this.numRecords) {
            throw new IndexOutOfBoundsException();
        }
        int bufferNum = logicalPosition / this.indexEntriesPerSegment;
        int segmentOffset = logicalPosition % this.indexEntriesPerSegment;
        return this.sortIndex.get(bufferNum).getLong(segmentOffset * this.indexEntrySize);
    }

    private final T getRecordFromBuffer(T reuse, long pointer) throws IOException {
        this.recordBuffer.setReadPosition(pointer);
        return (T)this.serializer.deserialize(reuse, (DataInputView)this.recordBuffer);
    }

    private final int compareRecords(long pointer1, long pointer2) {
        this.recordBuffer.setReadPosition(pointer1);
        this.recordBufferForComparison.setReadPosition(pointer2);
        try {
            return this.comparator.compare((DataInputView)this.recordBuffer, (DataInputView)this.recordBufferForComparison);
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error comparing two records.", ioex);
        }
    }

    private final boolean memoryAvailable() {
        return !this.freeMemory.isEmpty();
    }

    private final MemorySegment nextMemorySegment() {
        return this.freeMemory.remove(this.freeMemory.size() - 1);
    }

    @Override
    public int compare(int i, int j) {
        MemorySegment segJ;
        int bufferNumI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int bufferNumJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        MemorySegment segI = this.sortIndex.get(bufferNumI);
        int val = MemorySegment.compare((MemorySegment)segI, (MemorySegment)(segJ = this.sortIndex.get(bufferNumJ)), (int)(segmentOffsetI + 8), (int)(segmentOffsetJ + 8), (int)this.numKeyBytes);
        if (val != 0 || this.normalizedKeyFullyDetermines) {
            return this.useNormKeyUninverted ? val : -val;
        }
        long pointerI = segI.getLong(segmentOffsetI);
        long pointerJ = segJ.getLong(segmentOffsetJ);
        return this.compareRecords(pointerI, pointerJ);
    }

    @Override
    public void swap(int i, int j) {
        int bufferNumI = i / this.indexEntriesPerSegment;
        int segmentOffsetI = i % this.indexEntriesPerSegment * this.indexEntrySize;
        int bufferNumJ = j / this.indexEntriesPerSegment;
        int segmentOffsetJ = j % this.indexEntriesPerSegment * this.indexEntrySize;
        MemorySegment segI = this.sortIndex.get(bufferNumI);
        MemorySegment segJ = this.sortIndex.get(bufferNumJ);
        MemorySegment.swapBytes((MemorySegment)segI, (MemorySegment)segJ, (byte[])this.swapBuffer, (int)segmentOffsetI, (int)segmentOffsetJ, (int)this.indexEntrySize);
    }

    @Override
    public int size() {
        return this.numRecords;
    }

    @Override
    public final MutableObjectIterator<T> getIterator() {
        return new MutableObjectIterator<T>(){
            private final int size;
            private int current;
            private int currentSegment;
            private int currentOffset;
            private MemorySegment currentIndexSegment;
            {
                this.size = NormalizedKeySorter.this.size();
                this.current = 0;
                this.currentSegment = 0;
                this.currentOffset = 0;
                this.currentIndexSegment = (MemorySegment)NormalizedKeySorter.this.sortIndex.get(0);
            }

            public T next(T target) {
                if (this.current < this.size) {
                    ++this.current;
                    if (this.currentOffset > NormalizedKeySorter.this.lastIndexEntryOffset) {
                        this.currentOffset = 0;
                        this.currentIndexSegment = (MemorySegment)NormalizedKeySorter.this.sortIndex.get(++this.currentSegment);
                    }
                    long pointer = this.currentIndexSegment.getLong(this.currentOffset);
                    this.currentOffset += NormalizedKeySorter.this.indexEntrySize;
                    try {
                        return NormalizedKeySorter.this.getRecordFromBuffer(target, pointer);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output) throws IOException {
        int recordsLeft = this.numRecords;
        int currentMemSeg = 0;
        while (recordsLeft > 0) {
            long pointer;
            int offset;
            MemorySegment currentIndexSegment = this.sortIndex.get(currentMemSeg++);
            if (recordsLeft >= this.indexEntriesPerSegment) {
                for (offset = 0; offset <= this.lastIndexEntryOffset; offset += this.indexEntrySize) {
                    pointer = currentIndexSegment.getLong(offset);
                    this.recordBuffer.setReadPosition(pointer);
                    this.serializer.copy((DataInputView)this.recordBuffer, (DataOutputView)output);
                }
                recordsLeft -= this.indexEntriesPerSegment;
                continue;
            }
            while (recordsLeft > 0) {
                pointer = currentIndexSegment.getLong(offset);
                this.recordBuffer.setReadPosition(pointer);
                this.serializer.copy((DataInputView)this.recordBuffer, (DataOutputView)output);
                --recordsLeft;
                offset += this.indexEntrySize;
            }
        }
    }

    @Override
    public void writeToOutput(ChannelWriterOutputView output, int start, int num) throws IOException {
        int currentMemSeg = start / this.indexEntriesPerSegment;
        int offset = start % this.indexEntriesPerSegment * this.indexEntrySize;
        while (num > 0) {
            long pointer;
            MemorySegment currentIndexSegment = this.sortIndex.get(currentMemSeg++);
            if (num >= this.indexEntriesPerSegment && offset == 0) {
                while (offset <= this.lastIndexEntryOffset) {
                    pointer = currentIndexSegment.getLong(offset);
                    this.recordBuffer.setReadPosition(pointer);
                    this.serializer.copy((DataInputView)this.recordBuffer, (DataOutputView)output);
                    offset += this.indexEntrySize;
                }
                num -= this.indexEntriesPerSegment;
            } else {
                while (num > 0 && offset <= this.lastIndexEntryOffset) {
                    pointer = currentIndexSegment.getLong(offset);
                    this.recordBuffer.setReadPosition(pointer);
                    this.serializer.copy((DataInputView)this.recordBuffer, (DataOutputView)output);
                    --num;
                    offset += this.indexEntrySize;
                }
            }
            offset = 0;
        }
    }
}

