/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.sort;

import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.sort.PartialOrderPriorityQueue;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public class MergeIterator<E>
implements MutableObjectIterator<E> {
    private final PartialOrderPriorityQueue<HeadStream<E>> heap;
    private final TypeSerializer<E> serializer;

    public MergeIterator(List<MutableObjectIterator<E>> iterators, TypeSerializer<E> serializer, TypeComparator<E> comparator) throws IOException {
        this.heap = new PartialOrderPriorityQueue(new HeadStreamComparator(), iterators.size());
        this.serializer = serializer;
        for (MutableObjectIterator<E> iterator : iterators) {
            this.heap.add(new HeadStream<E>(iterator, serializer, comparator.duplicate()));
        }
    }

    public E next(E reuse) throws IOException {
        if (this.heap.size() > 0) {
            HeadStream<E> top = this.heap.peek();
            reuse = this.serializer.copy(top.getHead(), reuse);
            if (!top.nextHead()) {
                this.heap.poll();
            } else {
                this.heap.adjustTop();
            }
            return reuse;
        }
        return null;
    }

    private static final class HeadStreamComparator<E>
    implements Comparator<HeadStream<E>> {
        private HeadStreamComparator() {
        }

        @Override
        public int compare(HeadStream<E> o1, HeadStream<E> o2) {
            return ((HeadStream)o2).comparator.compareToReference(((HeadStream)o1).comparator);
        }
    }

    private static final class HeadStream<E> {
        private final MutableObjectIterator<E> iterator;
        private final TypeComparator<E> comparator;
        private E head;

        public HeadStream(MutableObjectIterator<E> iterator, TypeSerializer<E> serializer, TypeComparator<E> comparator) throws IOException {
            this.iterator = iterator;
            this.comparator = comparator;
            this.head = serializer.createInstance();
            if (!this.nextHead()) {
                throw new IllegalStateException();
            }
        }

        public E getHead() {
            return this.head;
        }

        public boolean nextHead() throws IOException {
            this.head = this.iterator.next(this.head);
            if (this.head != null) {
                this.comparator.setReference(this.head);
                return true;
            }
            return false;
        }
    }
}

