/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.shipping;

import eu.stratosphere.api.common.distributions.DataDistribution;
import eu.stratosphere.api.common.typeutils.TypeComparator;
import eu.stratosphere.pact.runtime.shipping.ShipStrategyType;
import eu.stratosphere.runtime.io.api.ChannelSelector;
import eu.stratosphere.types.Key;
import eu.stratosphere.types.Record;

public class RecordOutputEmitter
implements ChannelSelector<Record> {
    private static final byte[] DEFAULT_SALT = new byte[]{17, 31, 47, 51, 83, 1};
    private final ShipStrategyType strategy;
    private final TypeComparator<Record> comparator;
    private int[] channels;
    private Key<?>[][] partitionBoundaries;
    private final DataDistribution distribution;
    private int nextChannelToSendTo;

    public RecordOutputEmitter(ShipStrategyType strategy) {
        this(strategy, null);
    }

    public RecordOutputEmitter(ShipStrategyType strategy, TypeComparator<Record> comparator) {
        this(strategy, comparator, null);
    }

    public RecordOutputEmitter(ShipStrategyType strategy, TypeComparator<Record> comparator, DataDistribution distr) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        this.strategy = strategy;
        this.comparator = comparator;
        this.distribution = distr;
        switch (strategy) {
            case FORWARD: 
            case PARTITION_HASH: 
            case PARTITION_RANGE: 
            case PARTITION_RANDOM: {
                this.channels = new int[1];
                break;
            }
            case BROADCAST: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid shipping strategy for OutputEmitter: " + strategy.name());
            }
        }
        if (strategy == ShipStrategyType.PARTITION_RANGE && distr == null) {
            throw new NullPointerException("Data distribution must not be null when the ship strategy is range partitioning.");
        }
    }

    @Override
    public final int[] selectChannels(Record record, int numberOfChannels) {
        switch (this.strategy) {
            case FORWARD: 
            case PARTITION_RANDOM: {
                return this.robin(numberOfChannels);
            }
            case PARTITION_HASH: {
                return this.hashPartitionDefault(record, numberOfChannels);
            }
            case PARTITION_RANGE: {
                return this.rangePartition(record, numberOfChannels);
            }
            case BROADCAST: {
                return this.broadcast(numberOfChannels);
            }
        }
        throw new UnsupportedOperationException("Unsupported distribution strategy: " + this.strategy.name());
    }

    private final int[] robin(int numberOfChannels) {
        int channel = this.nextChannelToSendTo;
        this.nextChannelToSendTo = channel > 0 ? channel - 1 : numberOfChannels - 1;
        this.channels[0] = channel;
        return this.channels;
    }

    private final int[] broadcast(int numberOfChannels) {
        if (this.channels == null || this.channels.length != numberOfChannels) {
            this.channels = new int[numberOfChannels];
            for (int i = 0; i < numberOfChannels; ++i) {
                this.channels[i] = i;
            }
        }
        return this.channels;
    }

    private final int[] hashPartitionDefault(Record record, int numberOfChannels) {
        int hash = this.comparator.hash((Object)record);
        for (int i = 0; i < DEFAULT_SALT.length; ++i) {
            hash ^= (hash << 5) + DEFAULT_SALT[i] + (hash >> 2);
        }
        this.channels[0] = hash < 0 ? (hash == Integer.MIN_VALUE ? Integer.MAX_VALUE % numberOfChannels : -hash % numberOfChannels) : hash % numberOfChannels;
        return this.channels;
    }

    private final int[] rangePartition(Record record, int numberOfChannels) {
        if (this.partitionBoundaries == null) {
            this.partitionBoundaries = new Key[numberOfChannels - 1][];
            for (int i = 0; i < numberOfChannels - 1; ++i) {
                this.partitionBoundaries[i] = this.distribution.getBucketBoundary(i, numberOfChannels);
            }
        }
        if (numberOfChannels == this.partitionBoundaries.length + 1) {
            Key<?>[][] boundaries = this.partitionBoundaries;
            this.comparator.setReference((Object)record);
            int low = 0;
            int high = this.partitionBoundaries.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int result = this.comparator.compareAgainstReference(boundaries[mid]);
                if (result < 0) {
                    low = mid + 1;
                    continue;
                }
                if (result > 0) {
                    high = mid - 1;
                    continue;
                }
                this.channels[0] = mid;
                return this.channels;
            }
            this.channels[0] = low;
            return this.channels;
        }
        throw new IllegalStateException("The number of channels to partition among is inconsistent with the partitioners state.");
    }
}

