/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.shipping;

import eu.stratosphere.api.common.operators.Order;
import eu.stratosphere.pact.runtime.shipping.PartitionFunction;
import eu.stratosphere.types.Record;
import java.util.Arrays;

public class HistogramPartitionFunction
implements PartitionFunction {
    private final Record[] splitBorders;
    private final Order partitionOrder;

    public HistogramPartitionFunction(Record[] splitBorders, Order partitionOrder) {
        this.splitBorders = splitBorders;
        this.partitionOrder = partitionOrder;
    }

    @Override
    public void selectChannels(Record data, int numChannels, int[] channels) {
        int pos = Arrays.binarySearch(this.splitBorders, data);
        if (pos < 0) {
            ++pos;
            pos = -pos;
        }
        channels[0] = this.partitionOrder == Order.ASCENDING || this.partitionOrder == Order.ANY ? pos : this.splitBorders.length - pos;
    }
}

