/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.task;

import eu.stratosphere.api.common.aggregators.Aggregator;
import eu.stratosphere.api.common.aggregators.AggregatorWithName;
import eu.stratosphere.types.Value;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RuntimeAggregatorRegistry {
    private final Map<String, Aggregator<?>> aggregators = new HashMap();
    private final Map<String, Value> previousGlobalAggregate = new HashMap<String, Value>();

    public RuntimeAggregatorRegistry(Collection<AggregatorWithName<?>> aggs) {
        for (AggregatorWithName<?> agg : aggs) {
            this.aggregators.put(agg.getName(), agg.getAggregator());
        }
    }

    public Value getPreviousGlobalAggregate(String name) {
        return this.previousGlobalAggregate.get(name);
    }

    public <T extends Aggregator<?>> T getAggregator(String name) {
        return (T)this.aggregators.get(name);
    }

    public Map<String, Aggregator<?>> getAllAggregators() {
        return this.aggregators;
    }

    public void updateGlobalAggregatesAndReset(String[] names, Value[] aggregates) {
        if (names == null || aggregates == null || names.length != aggregates.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < names.length; ++i) {
            this.previousGlobalAggregate.put(names[i], aggregates[i]);
        }
        for (Aggregator<?> agg : this.aggregators.values()) {
            agg.reset();
        }
    }
}

