/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.task;

import eu.stratosphere.api.common.functions.Function;
import eu.stratosphere.pact.runtime.iterative.concurrent.SolutionSetUpdateBarrier;
import eu.stratosphere.pact.runtime.iterative.concurrent.SolutionSetUpdateBarrierBroker;
import eu.stratosphere.pact.runtime.iterative.io.WorksetUpdateOutputCollector;
import eu.stratosphere.pact.runtime.iterative.task.AbstractIterativePactTask;
import eu.stratosphere.pact.runtime.task.PactTaskContext;
import eu.stratosphere.util.Collector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IterationTailPactTask<S extends Function, OT>
extends AbstractIterativePactTask<S, OT>
implements PactTaskContext<S, OT> {
    private static final Log log = LogFactory.getLog(IterationTailPactTask.class);
    private SolutionSetUpdateBarrier solutionSetUpdateBarrier;
    private WorksetUpdateOutputCollector<OT> worksetUpdateOutputCollector;

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        if (!this.isWorksetUpdate && !this.isSolutionSetUpdate) {
            throw new RuntimeException("The iteration tail doesn't update workset or the solution set.");
        }
        Collector outputCollector = null;
        if (this.isWorksetUpdate) {
            outputCollector = this.createWorksetUpdateOutputCollector();
            if (this.isWorksetIteration) {
                this.worksetUpdateOutputCollector = (WorksetUpdateOutputCollector)outputCollector;
            }
        }
        if (this.isSolutionSetUpdate) {
            outputCollector = this.isWorksetIteration ? this.createSolutionSetUpdateOutputCollector(outputCollector) : new Collector<OT>(){

                public void collect(OT record) {
                }

                public void close() {
                }
            };
            if (!this.isWorksetUpdate) {
                this.solutionSetUpdateBarrier = SolutionSetUpdateBarrierBroker.instance().get(this.brokerKey());
            }
        }
        this.setLastOutputCollector(outputCollector);
    }

    @Override
    public void run() throws Exception {
        while (this.running && !this.terminationRequested()) {
            if (log.isInfoEnabled()) {
                log.info((Object)this.formatLogString("starting iteration [" + this.currentIteration() + "]"));
            }
            try {
                super.run();
            }
            catch (NullPointerException e) {
                boolean terminationRequested = this.terminationRequested();
                System.out.println("Nullpoint exception when termination requested was " + terminationRequested);
            }
            this.checkForTerminationAndResetEndOfSuperstepState();
            if (this.isWorksetUpdate && this.isWorksetIteration) {
                long numCollected = this.worksetUpdateOutputCollector.getElementsCollectedAndReset();
                this.worksetAggregator.aggregate(numCollected);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)this.formatLogString("finishing iteration [" + this.currentIteration() + "]"));
            }
            if (this.terminationRequested()) continue;
            if (this.isWorksetUpdate) {
                this.worksetBackChannel.notifyOfEndOfSuperstep();
            } else if (this.isSolutionSetUpdate) {
                this.solutionSetUpdateBarrier.notifySolutionSetUpdate();
            }
            this.incrementIterationCounter();
        }
    }
}

