/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.task;

import eu.stratosphere.api.common.functions.Function;
import eu.stratosphere.pact.runtime.iterative.io.WorksetUpdateOutputCollector;
import eu.stratosphere.pact.runtime.iterative.task.AbstractIterativePactTask;
import eu.stratosphere.runtime.io.api.BufferWriter;
import eu.stratosphere.util.Collector;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IterationIntermediatePactTask<S extends Function, OT>
extends AbstractIterativePactTask<S, OT> {
    private static final Log log = LogFactory.getLog(IterationIntermediatePactTask.class);
    private WorksetUpdateOutputCollector<OT> worksetUpdateOutputCollector;

    @Override
    protected void initialize() throws Exception {
        super.initialize();
        Collector delegate = this.getLastOutputCollector();
        if (this.isWorksetUpdate) {
            if (this.isSolutionSetUpdate) {
                throw new IllegalStateException("Plan bug: Intermediate task performs workset and solutions set update.");
            }
            Collector outputCollector = this.createWorksetUpdateOutputCollector(delegate);
            if (this.isWorksetIteration) {
                this.worksetUpdateOutputCollector = (WorksetUpdateOutputCollector)outputCollector;
            }
            this.setLastOutputCollector(outputCollector);
        } else if (this.isSolutionSetUpdate) {
            this.setLastOutputCollector(this.createSolutionSetUpdateOutputCollector(delegate));
        }
    }

    @Override
    public void run() throws Exception {
        while (this.running && !this.terminationRequested()) {
            if (log.isInfoEnabled()) {
                log.info((Object)this.formatLogString("starting iteration [" + this.currentIteration() + "]"));
            }
            super.run();
            this.checkForTerminationAndResetEndOfSuperstepState();
            if (this.isWorksetUpdate && this.isWorksetIteration) {
                long numCollected = this.worksetUpdateOutputCollector.getElementsCollectedAndReset();
                this.worksetAggregator.aggregate(numCollected);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)this.formatLogString("finishing iteration [" + this.currentIteration() + "]"));
            }
            if (this.terminationRequested()) continue;
            if (this.isWorksetUpdate) {
                this.worksetBackChannel.notifyOfEndOfSuperstep();
            }
            this.sendEndOfSuperstep();
            this.incrementIterationCounter();
        }
    }

    private void sendEndOfSuperstep() throws IOException, InterruptedException {
        for (BufferWriter eventualOutput : this.eventualOutputs) {
            eventualOutput.sendEndOfSuperstep();
        }
    }
}

