/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.io;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.util.Collector;
import java.io.IOException;

public class WorksetUpdateOutputCollector<T>
implements Collector<T> {
    private final TypeSerializer<T> serializer;
    private final DataOutputView outputView;
    private long elementsCollected;
    private Collector<T> delegate;

    public WorksetUpdateOutputCollector(DataOutputView outputView, TypeSerializer<T> serializer) {
        this(outputView, serializer, null);
    }

    public WorksetUpdateOutputCollector(DataOutputView outputView, TypeSerializer<T> serializer, Collector<T> delegate) {
        this.outputView = outputView;
        this.serializer = serializer;
        this.delegate = delegate;
        this.elementsCollected = 0L;
    }

    public void collect(T record) {
        try {
            this.serializer.serialize(record, this.outputView);
            if (this.delegate != null) {
                this.delegate.collect(record);
            }
            ++this.elementsCollected;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize the record", e);
        }
    }

    public long getElementsCollectedAndReset() {
        long elementsCollectedToReturn = this.elementsCollected;
        this.elementsCollected = 0L;
        return elementsCollectedToReturn;
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

