/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.io;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.hash.CompactingHashTable;
import eu.stratosphere.util.Collector;
import java.io.IOException;

public class SolutionSetFastUpdateOutputCollector<T>
implements Collector<T> {
    private final Collector<T> delegate;
    private final CompactingHashTable<T> solutionSet;
    private final T tmpHolder;

    public SolutionSetFastUpdateOutputCollector(CompactingHashTable<T> solutionSet, TypeSerializer<T> serializer) {
        this(solutionSet, serializer, null);
    }

    public SolutionSetFastUpdateOutputCollector(CompactingHashTable<T> solutionSet, TypeSerializer<T> serializer, Collector<T> delegate) {
        this.solutionSet = solutionSet;
        this.delegate = delegate;
        this.tmpHolder = serializer.createInstance();
    }

    public void collect(T record) {
        try {
            this.solutionSet.insertOrReplaceRecord(record, this.tmpHolder);
            if (this.delegate != null) {
                this.delegate.collect(record);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

