/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.io;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.pact.runtime.hash.HashPartition;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;

public class HashPartitionIterator<BT, PT>
implements MutableObjectIterator<BT> {
    private final Iterator<HashPartition<BT, PT>> partitions;
    private final TypeSerializer<BT> serializer;
    private HashPartition<BT, PT> currentPartition;

    public HashPartitionIterator(Iterator<HashPartition<BT, PT>> partitions, TypeSerializer<BT> serializer) {
        this.partitions = partitions;
        this.serializer = serializer;
        this.currentPartition = null;
    }

    public BT next(BT reuse) throws IOException {
        if (this.currentPartition == null) {
            if (!this.partitions.hasNext()) {
                return null;
            }
            this.currentPartition = this.partitions.next();
            this.currentPartition.setReadPosition(0L);
        }
        try {
            reuse = this.serializer.deserialize(reuse, this.currentPartition);
        }
        catch (EOFException e) {
            reuse = this.advanceAndRead(reuse);
        }
        return reuse;
    }

    private BT advanceAndRead(BT reuse) throws IOException {
        if (!this.partitions.hasNext()) {
            return null;
        }
        this.currentPartition = this.partitions.next();
        this.currentPartition.setReadPosition(0L);
        try {
            reuse = this.serializer.deserialize(reuse, this.currentPartition);
        }
        catch (EOFException e) {
            reuse = this.advanceAndRead(reuse);
        }
        return reuse;
    }
}

