/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.event;

import eu.stratosphere.api.common.aggregators.Aggregator;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.core.memory.InputViewDataInputStreamWrapper;
import eu.stratosphere.core.memory.OutputViewDataOutputStreamWrapper;
import eu.stratosphere.nephele.event.task.AbstractTaskEvent;
import eu.stratosphere.types.Value;
import eu.stratosphere.util.InstantiationUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public abstract class IterationEventWithAggregators
extends AbstractTaskEvent {
    protected static final String[] NO_STRINGS = new String[0];
    protected static final Value[] NO_VALUES = new Value[0];
    private String[] aggNames;
    private String[] classNames;
    private byte[][] serializedData;
    private Value[] aggregates;

    protected IterationEventWithAggregators() {
        this.aggNames = NO_STRINGS;
        this.aggregates = NO_VALUES;
    }

    protected IterationEventWithAggregators(String aggregatorName, Value aggregate) {
        if (aggregatorName == null || aggregate == null) {
            throw new NullPointerException();
        }
        this.aggNames = new String[]{aggregatorName};
        this.aggregates = new Value[]{aggregate};
    }

    protected IterationEventWithAggregators(Map<String, Aggregator<?>> aggregators) {
        int num = aggregators.size();
        if (num == 0) {
            this.aggNames = NO_STRINGS;
            this.aggregates = NO_VALUES;
        } else {
            this.aggNames = new String[num];
            this.aggregates = new Value[num];
            int i = 0;
            for (Map.Entry<String, Aggregator<?>> entry : aggregators.entrySet()) {
                this.aggNames[i] = entry.getKey();
                this.aggregates[i] = entry.getValue().getAggregate();
                ++i;
            }
        }
    }

    public String[] getAggregatorNames() {
        return this.aggNames;
    }

    public Value[] getAggregates(ClassLoader classResolver) {
        if (this.aggregates == null) {
            int num = this.aggNames.length;
            this.aggregates = new Value[num];
            for (int i = 0; i < num; ++i) {
                Value v;
                try {
                    Class<Value> valClass = Class.forName(this.classNames[i], true, classResolver).asSubclass(Value.class);
                    v = (Value)InstantiationUtil.instantiate(valClass, Value.class);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not load user-defined class '" + this.classNames[i] + "'.", e);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException("User-defined aggregator class is not a value sublass.");
                }
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.serializedData[i]));
                try {
                    v.read((DataInputView)new InputViewDataInputStreamWrapper(in));
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while deserializing the user-defined aggregate class.", e);
                }
                this.aggregates[i] = v;
            }
        }
        return this.aggregates;
    }

    public void write(DataOutputView out) throws IOException {
        int num = this.aggNames.length;
        out.writeInt(num);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        DataOutputStream bufferStream = new DataOutputStream(boas);
        for (int i = 0; i < num; ++i) {
            out.writeUTF(this.aggNames[i]);
            out.writeUTF(this.aggregates[i].getClass().getName());
            this.aggregates[i].write((DataOutputView)new OutputViewDataOutputStreamWrapper(bufferStream));
            bufferStream.flush();
            byte[] bytes = boas.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
            boas.reset();
        }
        bufferStream.close();
        boas.close();
    }

    public void read(DataInputView in) throws IOException {
        int num = in.readInt();
        if (num == 0) {
            this.aggNames = NO_STRINGS;
            this.aggregates = NO_VALUES;
        } else {
            if (this.aggNames == null || num > this.aggNames.length) {
                this.aggNames = new String[num];
            }
            if (this.classNames == null || num > this.classNames.length) {
                this.classNames = new String[num];
            }
            if (this.serializedData == null || num > this.serializedData.length) {
                this.serializedData = new byte[num][];
            }
            for (int i = 0; i < num; ++i) {
                this.aggNames[i] = in.readUTF();
                this.classNames[i] = in.readUTF();
                int len = in.readInt();
                byte[] data = new byte[len];
                this.serializedData[i] = data;
                in.readFully(data);
            }
            this.aggregates = null;
        }
    }
}

