/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.concurrent;

import eu.stratosphere.nephele.event.task.AbstractTaskEvent;
import eu.stratosphere.nephele.event.task.EventListener;
import eu.stratosphere.pact.runtime.iterative.event.AllWorkersDoneEvent;
import eu.stratosphere.pact.runtime.iterative.event.TerminationEvent;
import eu.stratosphere.types.Value;
import java.util.concurrent.CountDownLatch;

public class SuperstepBarrier
implements EventListener {
    private final ClassLoader userCodeClassLoader;
    private boolean terminationSignaled = false;
    private CountDownLatch latch;
    private String[] aggregatorNames;
    private Value[] aggregates;

    public SuperstepBarrier(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = userCodeClassLoader;
    }

    public void setup() {
        this.latch = new CountDownLatch(1);
    }

    public void waitForOtherWorkers() throws InterruptedException {
        this.latch.await();
    }

    public String[] getAggregatorNames() {
        return this.aggregatorNames;
    }

    public Value[] getAggregates() {
        return this.aggregates;
    }

    @Override
    public void eventOccurred(AbstractTaskEvent event) {
        if (event instanceof TerminationEvent) {
            this.terminationSignaled = true;
        } else if (event instanceof AllWorkersDoneEvent) {
            AllWorkersDoneEvent wde = (AllWorkersDoneEvent)event;
            this.aggregatorNames = wde.getAggregatorNames();
            this.aggregates = wde.getAggregates(this.userCodeClassLoader);
        } else {
            throw new IllegalArgumentException("Unknown event type.");
        }
        this.latch.countDown();
    }

    public boolean terminationSignaled() {
        return this.terminationSignaled;
    }
}

