/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.iterative.concurrent;

import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.pact.runtime.iterative.io.SerializedUpdateBuffer;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class BlockingBackChannel {
    private final SerializedUpdateBuffer buffer;
    private final BlockingQueue<SerializedUpdateBuffer> queue;

    public BlockingBackChannel(SerializedUpdateBuffer buffer) {
        this.buffer = buffer;
        this.queue = new ArrayBlockingQueue<SerializedUpdateBuffer>(1);
    }

    public DataInputView getReadEndAfterSuperstepEnded() {
        try {
            return this.queue.take().switchBuffers();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DataOutputView getWriteEnd() {
        return this.buffer;
    }

    public void notifyOfEndOfSuperstep() {
        this.queue.offer(this.buffer);
    }
}

