/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.io;

import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.core.memory.MemorySegmentSource;
import eu.stratosphere.nephele.services.iomanager.BlockChannelReader;
import eu.stratosphere.nephele.services.iomanager.BlockChannelWriter;
import eu.stratosphere.nephele.services.iomanager.HeaderlessChannelReaderInputView;
import eu.stratosphere.nephele.services.iomanager.IOManager;
import eu.stratosphere.nephele.services.memorymanager.AbstractPagedOutputView;
import eu.stratosphere.pact.runtime.io.RandomAccessInputView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SpillingBuffer
extends AbstractPagedOutputView {
    private final ArrayList<MemorySegment> fullSegments = new ArrayList(16);
    private final MemorySegmentSource memorySource;
    private BlockChannelWriter writer;
    private RandomAccessInputView inMemInView;
    private HeaderlessChannelReaderInputView externalInView;
    private final IOManager ioManager;
    private int blockCount;
    private int numBytesInLastSegment;
    private int numMemorySegmentsInWriter;

    public SpillingBuffer(IOManager ioManager, MemorySegmentSource memSource, int segmentSize) {
        super(memSource.nextSegment(), segmentSize, 0);
        this.memorySource = memSource;
        this.ioManager = ioManager;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
        if (this.writer == null) {
            this.fullSegments.add(current);
            MemorySegment nextSeg = this.memorySource.nextSegment();
            if (nextSeg != null) {
                return nextSeg;
            }
            this.writer = this.ioManager.createBlockChannelWriter(this.ioManager.createChannel());
            this.numMemorySegmentsInWriter = this.blockCount = this.fullSegments.size();
            for (int i = 0; i < this.fullSegments.size(); ++i) {
                this.writer.writeBlock(this.fullSegments.get(i));
            }
            this.fullSegments.clear();
            MemorySegment seg = this.writer.getNextReturnedSegment();
            --this.numMemorySegmentsInWriter;
            return seg;
        }
        this.writer.writeBlock(current);
        ++this.blockCount;
        return this.writer.getNextReturnedSegment();
    }

    public DataInputView flip() throws IOException {
        if (this.getCurrentSegment() != null) {
            if (this.writer == null) {
                this.fullSegments.add(this.getCurrentSegment());
                this.numBytesInLastSegment = this.getCurrentPositionInSegment();
                this.inMemInView = new RandomAccessInputView(this.fullSegments, this.segmentSize, this.numBytesInLastSegment);
            } else {
                this.writer.writeBlock(this.getCurrentSegment());
                ++this.numMemorySegmentsInWriter;
                this.numBytesInLastSegment = this.getCurrentPositionInSegment();
                ++this.blockCount;
                this.writer.close();
                for (int i = this.numMemorySegmentsInWriter; i > 0; --i) {
                    this.fullSegments.add(this.writer.getNextReturnedSegment());
                }
                this.numMemorySegmentsInWriter = 0;
            }
            this.clear();
        }
        if (this.writer == null) {
            this.inMemInView.setReadPosition(0L);
            return this.inMemInView;
        }
        if (this.externalInView != null) {
            this.externalInView.close();
        }
        BlockChannelReader reader = this.ioManager.createBlockChannelReader(this.writer.getChannelID());
        this.externalInView = new HeaderlessChannelReaderInputView(reader, this.fullSegments, this.blockCount, this.numBytesInLastSegment, false);
        return this.externalInView;
    }

    public List<MemorySegment> close() throws IOException {
        ArrayList<MemorySegment> segments = new ArrayList<MemorySegment>(this.fullSegments.size() + this.numMemorySegmentsInWriter);
        if (this.getCurrentSegment() != null) {
            segments.add(this.getCurrentSegment());
            this.clear();
        }
        SpillingBuffer.moveAll(this.fullSegments, segments);
        this.fullSegments.clear();
        if (this.writer != null) {
            this.writer.close();
            for (int i = this.numMemorySegmentsInWriter; i > 0; --i) {
                segments.add(this.writer.getNextReturnedSegment());
            }
            this.writer.closeAndDelete();
            this.writer = null;
        }
        if (this.inMemInView != null) {
            this.inMemInView = null;
        }
        if (this.externalInView != null) {
            if (!this.externalInView.isClosed()) {
                this.externalInView.close();
            }
            this.externalInView = null;
        }
        return segments;
    }

    private static final <E> void moveAll(ArrayList<E> source, ArrayList<E> target) {
        target.ensureCapacity(target.size() + source.size());
        for (int i = source.size() - 1; i >= 0; --i) {
            target.add(source.remove(i));
        }
    }
}

