/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.io;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.core.memory.MemorySegmentSource;
import eu.stratosphere.nephele.services.memorymanager.AbstractPagedOutputView;
import eu.stratosphere.pact.runtime.util.MathUtils;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public class SimpleCollectingOutputView
extends AbstractPagedOutputView {
    private final List<MemorySegment> fullSegments;
    private final MemorySegmentSource memorySource;
    private final int segmentSizeBits;
    private int segmentNum;

    public SimpleCollectingOutputView(List<MemorySegment> fullSegmentTarget, MemorySegmentSource memSource, int segmentSize) {
        super(memSource.nextSegment(), segmentSize, 0);
        this.segmentSizeBits = MathUtils.log2strict(segmentSize);
        this.fullSegments = fullSegmentTarget;
        this.memorySource = memSource;
        this.fullSegments.add(this.getCurrentSegment());
    }

    public void reset() {
        if (this.fullSegments.size() != 0) {
            throw new IllegalStateException("The target list still contains memory segments.");
        }
        this.clear();
        try {
            this.advance();
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error getting first segment for record collector.", ioex);
        }
        this.segmentNum = 0;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws EOFException {
        MemorySegment next = this.memorySource.nextSegment();
        if (next != null) {
            this.fullSegments.add(next);
            ++this.segmentNum;
            return next;
        }
        throw new EOFException();
    }

    public long getCurrentOffset() {
        return ((long)this.segmentNum << this.segmentSizeBits) + (long)this.getCurrentPositionInSegment();
    }
}

