/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.io;

import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.core.memory.SeekableDataOutputView;
import eu.stratosphere.nephele.services.memorymanager.AbstractPagedOutputView;
import eu.stratosphere.pact.runtime.util.MathUtils;
import java.io.EOFException;

public class RandomAccessOutputView
extends AbstractPagedOutputView
implements SeekableDataOutputView {
    private final MemorySegment[] segments;
    private int currentSegmentIndex;
    private final int segmentSizeBits;
    private final int segmentSizeMask;

    public RandomAccessOutputView(MemorySegment[] segments, int segmentSize) {
        this(segments, segmentSize, MathUtils.log2strict(segmentSize));
    }

    public RandomAccessOutputView(MemorySegment[] segments, int segmentSize, int segmentSizeBits) {
        super(segments[0], segmentSize, 0);
        if ((segmentSize & segmentSize - 1) != 0) {
            throw new IllegalArgumentException("Segment size must be a power of 2!");
        }
        this.segments = segments;
        this.segmentSizeBits = segmentSizeBits;
        this.segmentSizeMask = segmentSize - 1;
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws EOFException {
        if (++this.currentSegmentIndex < this.segments.length) {
            return this.segments[this.currentSegmentIndex];
        }
        throw new EOFException();
    }

    public void setWritePosition(long position) {
        int bufferNum = (int)(position >>> this.segmentSizeBits);
        int offset = (int)(position & (long)this.segmentSizeMask);
        this.currentSegmentIndex = bufferNum;
        this.seekOutput(this.segments[bufferNum], offset);
    }
}

