/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.io;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.nephele.services.iomanager.BlockChannelReader;
import eu.stratosphere.nephele.services.iomanager.Channel;
import eu.stratosphere.nephele.services.iomanager.ChannelReaderInputView;
import eu.stratosphere.nephele.services.iomanager.IOManager;
import eu.stratosphere.util.MutableObjectIterator;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;

public class ChannelReaderInputViewIterator<E>
implements MutableObjectIterator<E> {
    private final ChannelReaderInputView inView;
    private final TypeSerializer<E> accessors;
    private final List<MemorySegment> freeMemTarget;

    public ChannelReaderInputViewIterator(IOManager ioAccess, Channel.ID channel, List<MemorySegment> segments, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors, int numBlocks) throws IOException {
        this(ioAccess, channel, new LinkedBlockingQueue<MemorySegment>(), segments, freeMemTarget, accessors, numBlocks);
    }

    public ChannelReaderInputViewIterator(IOManager ioAccess, Channel.ID channel, LinkedBlockingQueue<MemorySegment> returnQueue, List<MemorySegment> segments, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors, int numBlocks) throws IOException {
        this(ioAccess.createBlockChannelReader(channel, returnQueue), returnQueue, segments, freeMemTarget, accessors, numBlocks);
    }

    public ChannelReaderInputViewIterator(BlockChannelReader reader, LinkedBlockingQueue<MemorySegment> returnQueue, List<MemorySegment> segments, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors, int numBlocks) throws IOException {
        this.accessors = accessors;
        this.freeMemTarget = freeMemTarget;
        this.inView = new ChannelReaderInputView(reader, segments, numBlocks, false);
    }

    public ChannelReaderInputViewIterator(ChannelReaderInputView inView, List<MemorySegment> freeMemTarget, TypeSerializer<E> accessors) {
        this.inView = inView;
        this.freeMemTarget = freeMemTarget;
        this.accessors = accessors;
    }

    public E next(E reuse) throws IOException {
        try {
            return (E)this.accessors.deserialize(reuse, (DataInputView)this.inView);
        }
        catch (EOFException eofex) {
            List<MemorySegment> freeMem = this.inView.close();
            if (this.freeMemTarget != null) {
                this.freeMemTarget.addAll(freeMem);
            }
            return null;
        }
    }
}

