/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.pact.runtime.hash;

import eu.stratosphere.api.common.typeutils.TypeSerializer;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.core.memory.MemorySegment;
import eu.stratosphere.core.memory.MemorySegmentSource;
import eu.stratosphere.core.memory.SeekableDataInputView;
import eu.stratosphere.nephele.services.memorymanager.AbstractPagedInputView;
import eu.stratosphere.nephele.services.memorymanager.AbstractPagedOutputView;
import eu.stratosphere.nephele.services.memorymanager.ListMemorySegmentSource;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InMemoryPartition<T> {
    protected MemorySegment[] overflowSegments = new MemorySegment[2];
    protected int numOverflowSegments = 0;
    protected int nextOverflowBucket = 0;
    private final TypeSerializer<T> serializer;
    private final ArrayList<MemorySegment> partitionPages;
    private final ListMemorySegmentSource availableMemory;
    private final WriteView writeView;
    private final ReadView readView;
    private long recordCounter;
    private int partitionNumber;
    private boolean compacted;

    public InMemoryPartition(TypeSerializer<T> serializer, int partitionNumber, ListMemorySegmentSource memSource, int pageSize, int pageSizeInBits) {
        this.serializer = serializer;
        this.partitionPages = new ArrayList(64);
        this.availableMemory = memSource;
        this.partitionNumber = partitionNumber;
        this.partitionPages.add(memSource.nextSegment());
        this.compacted = true;
        this.writeView = new WriteView(this.partitionPages, memSource, pageSize, pageSizeInBits);
        this.readView = new ReadView(this.partitionPages, pageSize, pageSizeInBits);
    }

    public int getPartitionNumber() {
        return this.partitionNumber;
    }

    public void setPartitionNumber(int number) {
        this.partitionNumber = number;
    }

    public int getBlockCount() {
        return this.partitionPages.size();
    }

    public long getRecordCount() {
        return this.recordCounter;
    }

    public void resetRecordCounter() {
        this.recordCounter = 0L;
    }

    public boolean isCompacted() {
        return this.compacted;
    }

    public void setCompaction(boolean compacted) {
        this.compacted = compacted;
    }

    public final long appendRecord(T record) throws IOException {
        long pointer = this.writeView.getCurrentPointer();
        try {
            this.serializer.serialize(record, (DataOutputView)this.writeView);
            ++this.recordCounter;
            return pointer;
        }
        catch (EOFException e) {
            this.writeView.resetTo(pointer);
            throw e;
        }
    }

    public void readRecordAt(long pointer, T record) throws IOException {
        this.readView.setReadPosition(pointer);
        this.serializer.deserialize(record, (DataInputView)this.readView);
    }

    @Deprecated
    public void overwriteRecordAt(long pointer, T record) throws IOException {
        long tmpPointer = this.writeView.getCurrentPointer();
        this.writeView.resetTo(pointer);
        this.serializer.serialize(record, (DataOutputView)this.writeView);
        this.writeView.resetTo(tmpPointer);
    }

    public void clearAllMemory(List<MemorySegment> target) {
        if (this.overflowSegments != null) {
            for (int k = 0; k < this.numOverflowSegments; ++k) {
                target.add(this.overflowSegments[k]);
            }
        }
        target.addAll(this.partitionPages);
        this.partitionPages.clear();
    }

    public void allocateSegments(int numberOfSegments) {
        while (this.getBlockCount() < numberOfSegments) {
            MemorySegment next = this.availableMemory.nextSegment();
            if (next != null) {
                this.partitionPages.add(next);
                continue;
            }
            return;
        }
    }

    public void releaseSegments(int maxSegmentNumber, ArrayList<MemorySegment> target) {
        while (this.getBlockCount() > maxSegmentNumber) {
            target.add(this.partitionPages.remove(this.partitionPages.size() - 1));
        }
    }

    public String toString() {
        return String.format("Partition %d - %d records, %d partition blocks, %d bucket overflow blocks", this.getPartitionNumber(), this.getRecordCount(), this.getBlockCount(), this.numOverflowSegments);
    }

    private static final class ReadView
    extends AbstractPagedInputView
    implements SeekableDataInputView {
        private final ArrayList<MemorySegment> segments;
        private final int segmentSizeBits;
        private final int segmentSizeMask;
        private int currentSegmentIndex;
        private int segmentNumberOffset;

        public ReadView(ArrayList<MemorySegment> segments, int segmentSize, int segmentSizeBits) {
            super(segments.get(0), segmentSize, 0);
            if ((segmentSize & segmentSize - 1) != 0) {
                throw new IllegalArgumentException("Segment size must be a power of 2!");
            }
            this.segments = segments;
            this.segmentSizeBits = segmentSizeBits;
            this.segmentSizeMask = segmentSize - 1;
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current) throws EOFException {
            if (++this.currentSegmentIndex < this.segments.size()) {
                return this.segments.get(this.currentSegmentIndex);
            }
            throw new EOFException();
        }

        @Override
        protected int getLimitForSegment(MemorySegment segment) {
            return this.segmentSizeMask + 1;
        }

        public void setReadPosition(long position) {
            int bufferNum = (int)(position >>> this.segmentSizeBits) - this.segmentNumberOffset;
            int offset = (int)(position & (long)this.segmentSizeMask);
            this.currentSegmentIndex = bufferNum;
            this.seekInput(this.segments.get(bufferNum), offset, this.segmentSizeMask + 1);
        }

        public void setSegmentNumberOffset(int offset) {
            this.segmentNumberOffset = offset;
        }
    }

    private static final class WriteView
    extends AbstractPagedOutputView {
        private final ArrayList<MemorySegment> pages;
        private final MemorySegmentSource memSource;
        private final int sizeBits;
        private final int sizeMask;
        private int currentPageNumber;
        private int segmentNumberOffset;

        private WriteView(ArrayList<MemorySegment> pages, MemorySegmentSource memSource, int pageSize, int pageSizeBits) {
            super(pages.get(0), pageSize, 0);
            this.pages = pages;
            this.memSource = memSource;
            this.sizeBits = pageSizeBits;
            this.sizeMask = pageSize - 1;
        }

        @Override
        protected MemorySegment nextSegment(MemorySegment current, int bytesUsed) throws IOException {
            MemorySegment next = this.memSource.nextSegment();
            if (next == null) {
                throw new EOFException();
            }
            this.pages.add(next);
            ++this.currentPageNumber;
            return next;
        }

        private long getCurrentPointer() {
            return ((long)this.currentPageNumber << this.sizeBits) + (long)this.getCurrentPositionInSegment();
        }

        private int resetTo(long pointer) {
            int pageNum = (int)(pointer >>> this.sizeBits);
            int offset = (int)(pointer & (long)this.sizeMask);
            this.currentPageNumber = pageNum;
            int posInArray = pageNum - this.segmentNumberOffset;
            this.seekOutput(this.pages.get(posInArray), offset);
            return posInArray;
        }

        public void setSegmentNumberOffset(int offset) {
            this.segmentNumberOffset = offset;
        }
    }
}

