/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.util;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;

public class SerializableHashSet<T extends IOReadableWritable>
extends HashSet<T>
implements IOReadableWritable {
    private static final long serialVersionUID = -4615823301768215807L;

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.size());
        for (IOReadableWritable entry : this) {
            StringRecord.writeString((DataOutput)out, (String)entry.getClass().getName());
            entry.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        int numberOfMapEntries = in.readInt();
        for (int i = 0; i < numberOfMapEntries; ++i) {
            String type = StringRecord.readString((DataInput)in);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            IOReadableWritable entry = null;
            try {
                entry = (IOReadableWritable)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            entry.read(in);
            this.add(entry);
        }
    }
}

