/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.util;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SerializableHashMap<K extends IOReadableWritable, V extends IOReadableWritable>
extends HashMap<K, V>
implements IOReadableWritable {
    private static final long serialVersionUID = 6693468726881121924L;

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            IOReadableWritable key = (IOReadableWritable)entry.getKey();
            IOReadableWritable value = (IOReadableWritable)entry.getValue();
            StringRecord.writeString((DataOutput)out, (String)key.getClass().getName());
            key.write(out);
            StringRecord.writeString((DataOutput)out, (String)value.getClass().getName());
            value.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        int numberOfMapEntries = in.readInt();
        for (int i = 0; i < numberOfMapEntries; ++i) {
            String keyType = StringRecord.readString((DataInput)in);
            Class<?> keyClass = null;
            try {
                keyClass = Class.forName(keyType);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            IOReadableWritable key = null;
            try {
                key = (IOReadableWritable)keyClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            key.read(in);
            String valueType = StringRecord.readString((DataInput)in);
            Class<?> valueClass = null;
            try {
                valueClass = Class.forName(valueType);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            IOReadableWritable value = null;
            try {
                value = (IOReadableWritable)valueClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            value.read(in);
            this.put(key, value);
        }
    }
}

