/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.util;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.util.StringUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class SerializableArrayList<E extends IOReadableWritable>
extends ArrayList<E>
implements IOReadableWritable {
    private static final long serialVersionUID = 8196856588290198537L;

    public SerializableArrayList() {
    }

    public SerializableArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.size());
        for (IOReadableWritable element : this) {
            StringRecord.writeString((DataOutput)out, (String)element.getClass().getName());
            element.write(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        this.clear();
        int numberOfElements = in.readInt();
        for (int i = 0; i < numberOfElements; ++i) {
            String elementType = StringRecord.readString((DataInput)in);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(elementType);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            IOReadableWritable element = null;
            try {
                element = (IOReadableWritable)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            element.read(in);
            this.add(element);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SerializableArrayList)) {
            return false;
        }
        SerializableArrayList sal = (SerializableArrayList)obj;
        if (this.size() != sal.size()) {
            return false;
        }
        Iterator it = this.iterator();
        Iterator it2 = sal.iterator();
        while (it.hasNext()) {
            Object obj2;
            IOReadableWritable e = (IOReadableWritable)it.next();
            if (e.equals(obj2 = it2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = Integer.MIN_VALUE;
        if (!this.isEmpty()) {
            IOReadableWritable e = (IOReadableWritable)this.get(0);
            hashCode += Math.abs(e.getClass().hashCode());
        }
        return hashCode += this.size();
    }
}

