/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public final class NativeCodeLoader {
    private static Set<String> loadedLibrarySet = new HashSet<String>();
    private static final String JAR_PREFIX = "META-INF/lib/";
    private static final int BUFSIZE = 8192;

    private NativeCodeLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibraryFromFile(String directory, String filename) throws IOException {
        String libraryPath = directory + File.separator + filename;
        Set<String> set = loadedLibrarySet;
        synchronized (set) {
            File outputFile = new File(directory, filename);
            if (!outputFile.exists()) {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                InputStream in = cl.getResourceAsStream(JAR_PREFIX + filename);
                if (in == null) {
                    throw new IOException("Unable to extract native library " + filename + " to " + directory);
                }
                FileOutputStream out = new FileOutputStream(outputFile);
                NativeCodeLoader.copy(in, out);
            }
            System.load(libraryPath);
            loadedLibrarySet.add(filename);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[8192];
        int len = 0;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLibraryLoaded(String libraryName) {
        Set<String> set = loadedLibrarySet;
        synchronized (set) {
            return loadedLibrarySet.contains(libraryName);
        }
    }
}

