/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarFileCreator {
    private static final String CLASS_EXTENSION = ".class";
    private final Set<Class<?>> classSet = new HashSet();
    private final File outputFile;

    public JarFileCreator(File outputFile) {
        this.outputFile = outputFile;
    }

    public synchronized void addClass(Class<?> clazz) {
        this.classSet.add(clazz);
    }

    public synchronized void createJarFile() throws IOException {
        byte[] buf = new byte[128];
        if (this.outputFile == null) {
            throw new IOException("Output file is null");
        }
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        }
        JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(this.outputFile), new Manifest());
        for (Class<?> clazz : this.classSet) {
            String entry = clazz.getName().replace('.', '/') + CLASS_EXTENSION;
            jos.putNextEntry(new JarEntry(entry));
            InputStream classInputStream = clazz.getResourceAsStream(clazz.getSimpleName() + CLASS_EXTENSION);
            int num = classInputStream.read(buf);
            while (num != -1) {
                jos.write(buf, 0, num);
                num = classInputStream.read(buf);
            }
            classInputStream.close();
            jos.closeEntry();
        }
        jos.close();
    }
}

