/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.util;

import eu.stratosphere.core.io.StringRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static <T extends Enum<T>> T readEnum(DataInput in, Class<T> enumType) throws IOException {
        if (!in.readBoolean()) {
            return null;
        }
        return Enum.valueOf(enumType, StringRecord.readString((DataInput)in));
    }

    public static void writeEnum(DataOutput out, Enum<?> enumVal) throws IOException {
        if (enumVal == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            StringRecord.writeString((DataOutput)out, (String)enumVal.name());
        }
    }
}

