/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.util;

import java.util.concurrent.atomic.AtomicInteger;

public class AtomicEnumerator<E> {
    private final E[] values;
    private final AtomicInteger next;

    public AtomicEnumerator(E[] values) {
        this.values = values;
        this.next = new AtomicInteger(0);
    }

    public E getNext() {
        int nv;
        int n;
        while (!this.next.compareAndSet(n, (nv = (n = this.next.get()) + 1) == this.values.length ? 0 : nv)) {
        }
        return this.values[n];
    }

    public static final <T> AtomicEnumerator<T> get(T[] values) {
        return new AtomicEnumerator<T>(values);
    }
}

