/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.types;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.io.StringRecord;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class FileRecord
implements IOReadableWritable {
    private String fileName;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private byte[] bytes = EMPTY_BYTES;

    public FileRecord() {
        this.fileName = "empty";
    }

    public FileRecord(String fileName) {
        this.fileName = fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getDataBuffer() {
        return this.bytes;
    }

    public void append(byte[] data, int start, int len) {
        int oldLength = this.bytes.length;
        this.setCapacity(this.bytes.length + len, true);
        System.arraycopy(data, start, this.bytes, oldLength, len);
    }

    private void setCapacity(int len, boolean keepData) {
        if (this.bytes == null || this.bytes.length < len) {
            byte[] newBytes = new byte[len];
            if (this.bytes != null && keepData) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            }
            this.bytes = newBytes;
        }
    }

    public void read(DataInputView in) throws IOException {
        this.fileName = StringRecord.readString((DataInput)in);
        int newLength = in.readInt();
        this.bytes = new byte[newLength];
        in.readFully(this.bytes, 0, newLength);
    }

    public void write(DataOutputView out) throws IOException {
        StringRecord.writeString((DataOutput)out, (String)this.fileName);
        out.writeInt(this.bytes.length);
        out.write(this.bytes, 0, this.bytes.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileRecord)) {
            return false;
        }
        FileRecord fr = (FileRecord)obj;
        if (this.bytes.length != fr.bytes.length) {
            return false;
        }
        return Arrays.equals(this.bytes, fr.bytes);
    }

    public int hashCode() {
        return (int)(11L * (long)this.bytes.length % Integer.MAX_VALUE);
    }
}

