/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.topology;

import eu.stratosphere.core.io.IOReadableWritable;
import eu.stratosphere.core.memory.DataInputView;
import eu.stratosphere.core.memory.DataOutputView;
import eu.stratosphere.nephele.topology.NetworkNode;
import eu.stratosphere.nephele.topology.NetworkTopologyIterator;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NetworkTopology
implements IOReadableWritable {
    private static final String DEFAULT_ROOT_NODE_NAME = "root";
    private static final String SEPARATOR = "/";
    private final NetworkNode rootNode;
    private final Map<String, NetworkNode> nodeMap = new HashMap<String, NetworkNode>();
    private Object attachment = null;

    public NetworkTopology() {
        this.rootNode = new NetworkNode(DEFAULT_ROOT_NODE_NAME, null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NetworkTopology fromFile(File topologyFile) throws IOException {
        NetworkTopology topology = new NetworkTopology();
        FileInputStream fstream = new FileInputStream(topologyFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Pattern pattern = Pattern.compile("^(\\S+)\\s*(\\S*)\\s*$");
        try {
            String strLine;
            while ((strLine = br.readLine()) != null && !strLine.isEmpty()) {
                Matcher m = pattern.matcher(strLine);
                if (!m.matches()) {
                    throw new IOException("Cannot extract topology information from line \"" + strLine + "\"");
                }
                strLine = m.group(1);
                if (strLine.charAt(0) == SEPARATOR.charAt(0)) {
                    strLine = strLine.substring(1);
                }
                String[] splits = strLine.split(SEPARATOR);
                NetworkNode previousNode = topology.getRootNode();
                for (int i = 0; i < splits.length; ++i) {
                    NetworkNode networkNode = topology.getNodeByName(splits[i]);
                    if (networkNode == null) {
                        networkNode = new NetworkNode(splits[i], previousNode, topology);
                    }
                    previousNode = networkNode;
                }
            }
        }
        finally {
            br.close();
        }
        return topology;
    }

    public static NetworkTopology fromFile(String topologyFileName) throws IOException {
        return NetworkTopology.fromFile(new File(topologyFileName));
    }

    public static NetworkTopology createEmptyTopology() {
        return new NetworkTopology();
    }

    void addNode(NetworkNode networkNode) {
        this.nodeMap.put(networkNode.getName(), networkNode);
    }

    public NetworkNode getNodeByName(String name) {
        return this.nodeMap.get(name);
    }

    public NetworkNode getRootNode() {
        return this.rootNode;
    }

    public void read(DataInputView in) throws IOException {
        this.rootNode.read(in);
    }

    public void write(DataOutputView out) throws IOException {
        this.rootNode.write(out);
    }

    public int getDepth() {
        return this.rootNode.getHeight();
    }

    public String toString() {
        return this.rootNode.toString();
    }

    void removeNode(NetworkNode networkNode) {
        this.nodeMap.remove(networkNode.getName());
    }

    public Iterator<NetworkNode> iterator() {
        return new NetworkTopologyIterator(this);
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }
}

