/*
 * Decompiled with CFR 0.152.
 */
package eu.stratosphere.nephele.taskmanager;

import eu.stratosphere.core.io.InputSplit;
import eu.stratosphere.nephele.executiongraph.ExecutionVertexID;
import eu.stratosphere.nephele.jobgraph.JobID;
import eu.stratosphere.nephele.jobmanager.splitassigner.InputSplitWrapper;
import eu.stratosphere.nephele.protocols.InputSplitProviderProtocol;
import eu.stratosphere.nephele.template.InputSplitProvider;
import eu.stratosphere.nephele.types.IntegerRecord;
import eu.stratosphere.util.StringUtils;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskInputSplitProvider
implements InputSplitProvider {
    private final JobID jobID;
    private final ExecutionVertexID executionVertexID;
    private final InputSplitProviderProtocol globalInputSplitProvider;
    private final AtomicInteger sequenceNumber = new AtomicInteger(0);

    TaskInputSplitProvider(JobID jobID, ExecutionVertexID executionVertexID, InputSplitProviderProtocol globalInputSplitProvider) {
        this.jobID = jobID;
        this.executionVertexID = executionVertexID;
        this.globalInputSplitProvider = globalInputSplitProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputSplit getNextInputSplit() {
        try {
            InputSplitProviderProtocol inputSplitProviderProtocol = this.globalInputSplitProvider;
            synchronized (inputSplitProviderProtocol) {
                InputSplitWrapper wrapper = this.globalInputSplitProvider.requestNextInputSplit(this.jobID, this.executionVertexID, new IntegerRecord(this.sequenceNumber.getAndIncrement()));
                return wrapper.getInputSplit();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(StringUtils.stringifyException((Throwable)ioe));
        }
    }
}

